/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;

public class WebLogicStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();

    public WebLogicStandaloneLocalConfiguration(File dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
        this.setProperty("cargo.weblogic.domain", "domain");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.createConfigurationDir();
        FilterChain filterChain = this.createWebLogicFilterChain();
        File testDomainDir = this.getFileUtils().createDirectory(this.getHome(), "domain");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/config.xml", new File(testDomainDir, "config.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/DefaultAuthenticatorInit.ldift", new File(testDomainDir, "DefaultAuthenticatorInit.ldift"), filterChain);
        this.setupDeployables((Container)container, testDomainDir);
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        StringBuffer appTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            String context = ((WAR)deployable).getContext();
            appTokenValue.append("<Application ");
            appTokenValue.append("Name=\"_" + context + "_app\" ");
            appTokenValue.append("Path=\"" + deployable.getFile().getParent() + "\" ");
            appTokenValue.append("StagedTargets=\"server\" StagingMode=\"stage\" TwoPhase=\"true\"");
            appTokenValue.append(">");
            appTokenValue.append("<WebAppComponent ");
            appTokenValue.append("Name=\"" + context + "\" ");
            appTokenValue.append("Targets=\"server\" ");
            appTokenValue.append("URI=\"" + context + "\"");
            appTokenValue.append("/></Application>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "weblogic.apps", appTokenValue.toString());
        return filterChain;
    }

    protected void setupDeployables(Container container, File domainDir) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            File appDir = this.getFileUtils().createDirectory(domainDir, "applications");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), new File(appDir, deployable.getFile().getName()), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + container.getName() + " [" + domainDir + "] domain directory", (Throwable)e);
        }
    }

    public String toString() {
        return "WebLogic Standalone Configuration";
    }
}

