/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.geronimo.internal.GeronimoStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public class Geronimo2xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new GeronimoStandaloneLocalConfigurationCapability();

    public Geronimo2xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.remote.username", "system");
        this.setProperty("cargo.remote.password", "manager");
        this.setProperty("cargo.geronimo.log.console", "INFO");
        this.setProperty("cargo.geronimo.log.file", "DEBUG");
        this.setProperty("cargo.geronimo.servlet.containerId", "tomcat");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createGeronimoFilterChain(container);
        String varDirectory = this.getHome() + "/var";
        if (!this.getFileHandler().exists(varDirectory)) {
            this.getFileHandler().createDirectory(this.getHome(), "/var");
            String originalVarDirectory = ((InstalledLocalContainer)container).getHome() + "/var";
            this.getFileHandler().copyDirectory(originalVarDirectory, varDirectory);
            String securityDir = this.getFileHandler().createDirectory(this.getHome(), "/var/security");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/users.properties", new File(securityDir, "users.properties"), filterChain);
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/groups.properties", new File(securityDir, "groups.properties"), filterChain);
            String keystoresDir = this.getFileHandler().createDirectory(securityDir, "var/keystores");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/keystore", new File(keystoresDir, "geronimo-default"));
            this.getFileHandler().createDirectory(this.getHome(), "/var/deploy");
            this.getFileHandler().createDirectory(this.getHome(), "/var/temp");
        }
    }

    protected FilterChain createGeronimoFilterChain(LocalContainer container) throws MalformedURLException {
        FilterChain filterChain = this.getFilterChain();
        String[] userTokens = this.getUserTokens();
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.users", userTokens[0]);
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.groups", userTokens[1]);
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.manager.username", this.getPropertyValue("cargo.remote.username"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.manager.password", this.getPropertyValue("cargo.remote.password"));
        return filterChain;
    }

    private String[] getUserTokens() {
        String[] tokens = new String[]{" ", " "};
        StringBuilder usersToken = new StringBuilder("");
        StringBuilder groupsToken = new StringBuilder("");
        String usersString = this.getPropertyValue("cargo.geronimo.users");
        if (usersString != null) {
            Iterator users = User.parseUsers(usersString).iterator();
            HashMap groupUsersMapping = new HashMap();
            while (users.hasNext()) {
                User user = (User)users.next();
                usersToken.append(user.getName());
                usersToken.append('=');
                usersToken.append(user.getPassword());
                usersToken.append(System.getProperty("line.separator"));
                List roles = user.getRoles();
                for (int i = 0; i < roles.size(); ++i) {
                    HashSet<String> groupUsers = (HashSet<String>)groupUsersMapping.get(roles.get(i));
                    if (groupUsers == null) {
                        groupUsers = new HashSet<String>();
                        groupUsersMapping.put(roles.get(i), groupUsers);
                    }
                    groupUsers.add(user.getName());
                }
            }
            Set groups = groupUsersMapping.keySet();
            for (Object key : groups) {
                Set gUsers = (Set)groupUsersMapping.get(key);
                groupsToken.append(key);
                groupsToken.append('=');
                Iterator iter2 = gUsers.iterator();
                while (iter2.hasNext()) {
                    groupsToken.append(iter2.next());
                    if (!iter2.hasNext()) continue;
                    groupsToken.append(',');
                }
                groupsToken.append(System.getProperty("line.separator"));
            }
            tokens[0] = usersToken.toString();
            tokens[1] = groupsToken.toString();
        }
        return tokens;
    }
}

