/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.glassfish;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.glassfish.GlassFish2xContainerCapability;
import org.codehaus.cargo.container.glassfish.internal.AbstractGlassFishInstalledLocalContainer;
import org.codehaus.cargo.util.CargoException;

public class GlassFish2xInstalledLocalContainer
extends AbstractGlassFishInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new GlassFish2xContainerCapability();

    public GlassFish2xInstalledLocalContainer(LocalConfiguration localConfiguration) {
        super(localConfiguration);
    }

    public void invokeAsAdmin(boolean async, Java java, String[] args) {
        String home = this.getHome();
        if (home == null || !this.getFileHandler().isDirectory(home)) {
            throw new CargoException("GlassFish home directory is not set");
        }
        File exec = File.pathSeparatorChar == ';' ? new File(home, "bin/asadmin.bat") : new File(home, "bin/asadmin");
        if (!exec.exists()) {
            throw new CargoException("asadmin command not found at " + exec);
        }
        if (File.pathSeparatorChar == ';') {
            try {
                Process p = Runtime.getRuntime().exec("chmod +x " + exec.getAbsolutePath());
                p.waitFor();
            }
            catch (InterruptedException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(exec.getAbsolutePath());
        for (String arg : args) {
            cmds.add(arg);
        }
        try {
            Execute exe = new Execute((ExecuteStreamHandler)new PumpStreamHandler(), new ExecuteWatchdog(30000L));
            exe.setAntRun(new Project());
            String[] arguments = new String[cmds.size()];
            cmds.toArray(arguments);
            exe.setCommandline(arguments);
            if (async) {
                exe.spawn();
            } else {
                int exitCode = exe.execute();
                if (exitCode != 0 && exitCode != 1) {
                    throw new CargoException(cmds + " failed. asadmin exited " + exitCode);
                }
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to invoke asadmin", e);
        }
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    public String getId() {
        return "glassfish2x";
    }

    public String getName() {
        return "GlassFish 2.x";
    }
}

