/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.glassfish;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Bundle;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.glassfish.GlassFishStandaloneLocalConfiguration;
import org.codehaus.cargo.container.glassfish.internal.AbstractGlassFishInstalledLocalContainer;
import org.codehaus.cargo.container.spi.deployer.AbstractLocalDeployer;

public class GlassFishInstalledLocalDeployer
extends AbstractLocalDeployer {
    public GlassFishInstalledLocalDeployer(InstalledLocalContainer localContainer) {
        super(localContainer);
    }

    protected AbstractGlassFishInstalledLocalContainer getLocalContainer() {
        return (AbstractGlassFishInstalledLocalContainer)super.getContainer();
    }

    private GlassFishStandaloneLocalConfiguration getConfiguration() {
        return (GlassFishStandaloneLocalConfiguration)this.getLocalContainer().getConfiguration();
    }

    public DeployerType getType() {
        return DeployerType.INSTALLED;
    }

    public void deploy(Deployable deployable) {
        this.doDeploy(deployable, false);
    }

    public void redeploy(Deployable deployable) {
        this.doDeploy(deployable, true);
    }

    protected void doDeploy(Deployable deployable, boolean overwrite) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("deploy");
        if (overwrite) {
            args.add("--force");
        }
        if (deployable instanceof WAR) {
            args.add("--contextroot");
            args.add(((WAR)deployable).getContext());
        } else if (deployable instanceof Bundle) {
            args.add("--type=osgi");
        }
        this.addConnectOptions(args);
        args.add(new File(deployable.getFile()).getAbsolutePath());
        String[] arguments = new String[args.size()];
        args.toArray(arguments);
        this.getLocalContainer().invokeAsAdmin(false, arguments);
    }

    public void undeploy(Deployable deployable) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("undeploy");
        this.addConnectOptions(args);
        args.add(this.cutExtension(this.getFileHandler().getName(deployable.getFile())));
        String[] arguments = new String[args.size()];
        args.toArray(arguments);
        this.getLocalContainer().invokeAsAdmin(false, arguments);
    }

    public void start(Deployable deployable) {
        super.start(deployable);
    }

    public void stop(Deployable deployable) {
        super.stop(deployable);
    }

    private String cutExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    private void addConnectOptions(List args) {
        args.add("--interactive=false");
        args.add("--port");
        args.add(this.getConfiguration().getPropertyValue("cargo.glassfish.adminPort"));
        args.add("--user");
        args.add(this.getConfiguration().getPropertyValue("cargo.remote.username"));
        args.add("--passwordfile");
        args.add(this.getConfiguration().getPasswordFile().getAbsolutePath());
    }
}

