/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.glassfish.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.glassfish.GlassFishInstalledLocalDeployer;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractGlassFishInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public AbstractGlassFishInstalledLocalContainer(LocalConfiguration localConfiguration) {
        super(localConfiguration);
    }

    public void invokeAsAdmin(boolean async, String[] args) {
        Java java = this.createJavaTask();
        this.addMemoryArguments(java);
        this.invokeAsAdmin(async, java, args);
    }

    public abstract void invokeAsAdmin(boolean var1, Java var2, String[] var3);

    protected void doStart(Java java) throws Exception {
        this.getConfiguration().configure(this);
        this.getLogger().debug("Starting domain on HTTP port " + this.getConfiguration().getPropertyValue("cargo.servlet.port") + " and admin port " + this.getConfiguration().getPropertyValue("cargo.glassfish.adminPort"), this.getClass().getName());
        this.invokeAsAdmin(true, java, new String[]{"start-domain", "--interactive=false", "--domaindir", this.getConfiguration().getHome(), this.getConfiguration().getPropertyValue("cargo.glassfish.domain.name")});
        boolean started = false;
        URL adminURL = new URL("http://" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.glassfish.adminPort") + "/");
        long timeout = System.currentTimeMillis() + this.getTimeout();
        while (System.currentTimeMillis() < timeout) {
            try {
                InputStream is = adminURL.openConnection().getInputStream();
                is.close();
                started = true;
                break;
            }
            catch (IOException e) {
                Thread.sleep(1000L);
            }
        }
        if (!started) {
            throw new CargoException("GlassFish server admin still not accessible on " + adminURL + " after " + this.getTimeout() + " milliseconds!");
        }
        GlassFishInstalledLocalDeployer deployer = new GlassFishInstalledLocalDeployer(this);
        Iterator iterator = this.getConfiguration().getDeployables().iterator();
        while (iterator.hasNext()) {
            deployer.deploy((Deployable)iterator.next());
        }
    }

    protected void doStop(Java java) throws Exception {
        this.invokeAsAdmin(false, java, new String[]{"stop-domain", "--domaindir", this.getConfiguration().getHome(), this.getConfiguration().getPropertyValue("cargo.glassfish.domain.name")});
    }
}

