/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.JBossStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jboss.internal.JBoss5xInstalledLocalContainer;

public class JBoss5xStandaloneLocalConfiguration
extends JBossStandaloneLocalConfiguration {
    public JBoss5xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected FilterChain createJBossFilterChain(JBoss5xInstalledLocalContainer container) throws MalformedURLException {
        FilterChain filterChain = super.createJBossFilterChain(container);
        File deployersDir = new File(container.getDeployersDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.deployers.url", deployersDir.toURI().toURL().toString());
        File deployDir = new File(container.getDeployDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.deploy.url", deployDir.toURI().toURL().toString());
        return filterChain;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        String[] cargoConfigDeployFiles;
        String[] cargoConfigBootstrapFiles;
        String[] cargoConfigFiles;
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.setupConfigurationDir();
        this.jbossContainer = (JBoss5xInstalledLocalContainer)container;
        FilterChain filterChain = this.createJBossFilterChain((JBoss5xInstalledLocalContainer)this.jbossContainer);
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(this.jbossContainer);
        deployer.deploy(this.getDeployables());
        if (container instanceof InstalledLocalContainer) {
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] sharedClassPath = installedContainer.getSharedClasspath();
            StringBuilder tmp = new StringBuilder();
            if (sharedClassPath != null) {
                for (String element : sharedClassPath) {
                    String fileName = this.getFileHandler().getName(element);
                    String directoryName = this.getFileHandler().getParent(element);
                    tmp.append("<classpath codebase=\"" + directoryName + "\" archives=\"" + fileName + "\"/>");
                    tmp.append("\n");
                }
            }
            String sharedClassPathString = tmp.toString();
            this.getLogger().debug("Shared loader classpath is " + sharedClassPathString, this.getClass().getName());
            this.getAntUtils().addTokenToFilterChain(filterChain, "jboss.shared.classpath", tmp.toString());
        }
        String deployDir = this.getFileHandler().createDirectory(this.getHome(), "/deploy");
        String deployersDir = this.getFileHandler().createDirectory(this.getHome(), "/deployers");
        String libDir = this.getFileHandler().createDirectory(this.getHome(), "/lib");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "/conf");
        String confBootstrapDir = this.getFileHandler().createDirectory(this.getHome(), "/conf/bootstrap");
        String clustered = this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered")).booleanValue()) {
            String farmDir = this.getFileHandler().createDirectory(this.getHome(), "/farm");
        }
        String[] configFiles = new String[]{"jboss-service.xml", "bindings.xml"};
        for (String cargoConfigFile : cargoConfigFiles = new String[]{"jboss-service.xml"}) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoConfigFile, new File(confDir, cargoConfigFile), filterChain);
        }
        for (String cargoConfigBootstrapFile : cargoConfigBootstrapFiles = new String[]{"bindings.xml"}) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoConfigBootstrapFile, new File(confBootstrapDir, cargoConfigBootstrapFile), filterChain);
        }
        for (String cargoConfigDeployFile : cargoConfigDeployFiles = new String[]{"ejb3-connectors-jboss-beans.xml"}) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoConfigDeployFile, new File(deployDir, cargoConfigDeployFile), filterChain);
        }
        this.copyExternalResources(new File(this.jbossContainer.getConfDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(confDir), configFiles);
        this.copyExternalResources(new File(this.jbossContainer.getDeployDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployDir), cargoConfigDeployFiles);
        this.copyExternalResources(new File(((JBoss5xInstalledLocalContainer)this.jbossContainer).getDeployersDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployersDir), new String[0]);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "/deploy/cargocpc.war"));
    }
}

