/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import org.codehaus.cargo.container.jboss.internal.ISimpleHttpFileServer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public class SimpleHttpFileServer
implements Runnable,
ISimpleHttpFileServer {
    protected Logger logger;
    protected URL url;
    protected FileHandler fileHandler;
    protected String filePath;
    protected String remotePath;
    protected ServerSocket serverSocket;
    protected int callCount = 0;
    protected boolean stopped;
    protected Throwable lastException;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setFile(FileHandler handler, String filePath) {
        if (!handler.exists(filePath) || handler.isDirectory(filePath)) {
            throw new CargoException("File " + filePath + " does not exist or is not a file");
        }
        String baseDir = handler.getParent(filePath);
        String fileName = handler.getName(filePath);
        this.filePath = filePath;
        this.fileHandler = handler;
        this.remotePath = "/" + fileName;
    }

    public void setListeningParameters(InetSocketAddress listenSocket, String remoteDeployAddress) {
        if (this.remotePath == null) {
            throw new CargoException("Please call setFile first!");
        }
        try {
            String finalRemoteDeployAddress = remoteDeployAddress;
            if (finalRemoteDeployAddress == null) {
                finalRemoteDeployAddress = listenSocket.getHostName();
            }
            this.url = new URL("http", finalRemoteDeployAddress, listenSocket.getPort(), this.remotePath);
        }
        catch (MalformedURLException e) {
            throw new CargoException("Could not create a url for " + listenSocket + " and file: " + this.remotePath, e);
        }
        try {
            this.serverSocket = new ServerSocket(listenSocket.getPort(), 0, listenSocket.getAddress());
        }
        catch (IOException e) {
            throw new CargoException("Could not create a socket for " + listenSocket, e);
        }
    }

    public URL getURL() {
        if (this.url == null) {
            throw new CargoException("Please call setListeningParameters first!");
        }
        return this.url;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public Throwable getException() {
        return this.lastException;
    }

    public void start() {
        if (this.logger == null) {
            throw new CargoException("Please call setLogger first!");
        }
        if (this.serverSocket == null) {
            throw new CargoException("Please call setListeningParameters first!");
        }
        this.stopped = false;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new CargoException("Error stopping embedded HTTP server", e);
        }
    }

    public void run() {
        block3: {
            try {
                this.runAndThrow();
            }
            catch (Throwable t) {
                if (this.stopped) break block3;
                this.lastException = t;
                this.logger.warn("Error in the embedded HTTP server: " + t.toString(), this.getClass().getName());
                for (StackTraceElement ste : t.getStackTrace()) {
                    this.logger.warn(ste.toString(), this.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndThrow() throws Throwable {
        String expectedGetRequest = "GET " + this.remotePath;
        while (true) {
            Socket socket = null;
            try {
                StringBuilder answer;
                this.logger.debug("Waiting for connection on socket " + this.serverSocket, this.getClass().getName());
                socket = this.serverSocket.accept();
                this.logger.debug("Handling request on socket " + socket, this.getClass().getName());
                boolean error = false;
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String line = in.readLine();
                if (line == null) {
                    line = "";
                }
                if (!line.startsWith(expectedGetRequest)) {
                    error = true;
                }
                while (!"".equals(line)) {
                    line = in.readLine();
                }
                this.logger.debug("Got HTTP request line " + line, this.getClass().getName());
                OutputStream out = socket.getOutputStream();
                if (error) {
                    answer = new StringBuilder();
                    answer.append("HTTP/1.0 404 NOTFOUND");
                    answer.append("\r\n");
                    answer.append("Connection: close");
                    answer.append("\r\n");
                    answer.append("\r\n");
                    out.write(answer.toString().getBytes("US-ASCII"));
                    out.flush();
                } else {
                    answer = new StringBuilder();
                    answer.append("HTTP/1.0 200 OK");
                    answer.append("\r\n");
                    answer.append("Connection: close");
                    answer.append("\r\n");
                    answer.append("Content-Type: application/octet-stream");
                    answer.append("\r\n");
                    answer.append("Content-Length: ");
                    answer.append(Long.toString(this.fileHandler.getSize(this.filePath)));
                    answer.append("\r\n");
                    answer.append("\r\n");
                    out.write(answer.toString().getBytes("US-ASCII"));
                    out.flush();
                    byte[] fileBytes = new byte[socket.getSendBufferSize()];
                    InputStream file = this.fileHandler.getInputStream(this.filePath);
                    try {
                        int read;
                        while ((read = file.read(fileBytes)) > 0) {
                            out.write(fileBytes, 0, read);
                            out.flush();
                        }
                    }
                    finally {
                        file.close();
                        file = null;
                    }
                    ++this.callCount;
                }
                this.logger.debug("Finished responding to HTTP request line " + line, this.getClass().getName());
                out.flush();
                out.close();
                out = null;
                in.close();
                in = null;
            }
            catch (SocketException socketException) {}
            continue;
            finally {
                if (socket == null) continue;
                socket.close();
                socket = null;
                continue;
            }
            break;
        }
    }
}

