/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.Jetty4xEmbeddedStandaloneLocalConfigurationCapability;

public class Jetty4xEmbeddedStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Jetty4xEmbeddedStandaloneLocalConfigurationCapability();

    public Jetty4xEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void activateLogging(LocalContainer container) throws Exception {
        ClassLoader cl = ((EmbeddedLocalContainer)container).getClassLoader();
        Class<?> outputStreamLogSinkClass = cl.loadClass("org.mortbay.util.OutputStreamLogSink");
        Object sink = outputStreamLogSinkClass.getConstructor(String.class).newInstance(container.getOutput());
        outputStreamLogSinkClass.getMethod("setAppend", Boolean.TYPE).invoke(sink, container.isAppend());
        outputStreamLogSinkClass.getMethod("start", null).invoke(sink, null);
        Class<?> sinkClass = cl.loadClass("org.mortbay.util.LogSink");
        Class<?> logClass = cl.loadClass("org.mortbay.util.Log");
        Object log = logClass.getMethod("instance", null).invoke(null, null);
        logClass.getMethod("disableLog", null).invoke(log, null);
        logClass.getMethod("add", sinkClass).invoke(log, sink);
        String logLevel = this.getPropertyValue("cargo.logging");
        if (logLevel.equalsIgnoreCase("high")) {
            Class<?> codeClass = cl.loadClass("org.mortbay.util.Code");
            codeClass.getMethod("setDebug", Boolean.TYPE).invoke(null, Boolean.TRUE);
        }
    }

    public String toString() {
        return "Jetty 4.x Embedded Standalone Configuration";
    }
}

