/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty7xInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public Jetty7xInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    protected void deployWar(String deployableDir, WAR war) {
        super.deployWar(deployableDir, war);
        String contextDir = this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "contexts");
        String contextFile = this.getFileHandler().append(contextDir, war.getContext() + ".xml");
        this.getFileHandler().createFile(contextFile);
        OutputStream out = this.getFileHandler().getOutputStream(contextFile);
        try {
            out.write(("<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://www.eclipse.org/jetty/configure.dtd\">\n<Configure class=\"org.eclipse.jetty.webapp.WebAppContext\">\n  <Set name=\"contextPath\">/" + war.getContext() + "</Set>\n" + "  <Set name=\"war\"><SystemProperty name=\"config.home\" " + "default=\".\"/>/webapps/" + war.getContext() + ".war</Set>\n" + "  <Set name=\"extractWAR\">true</Set>\n" + "  <Set name=\"defaultsDescriptor\"><SystemProperty name=\"config.home\" " + "default=\".\"/>/etc/webdefault.xml</Set>\n" + "</Configure>").getBytes());
            out.close();
        }
        catch (IOException e) {
            throw new ContainerException("Failed to create Jetty Context file for [" + war.getFile() + "]");
        }
    }
}

