/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jo;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public class Jo1xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "jo1x";
    public static final String NAME = "jo! 1.x";
    private ContainerCapability capability = new ServletContainerCapability();

    public Jo1xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public void doStart(Java java) throws Exception {
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        fileSet.createInclude().setName("*.jar");
        fileSet.createInclude().setName("system/*.jar");
        classpath.addFileset(fileSet);
        this.addToolsJarToClasspath(classpath);
        java.setClassname("com.tagtraum.bootstrap.Bootstrap");
        java.createArg().setValue("cl.jo=" + new File(this.getHome(), "lib") + "/*.jar");
        java.createArg().setValue("main.jo=com.tagtraum.jo.JoIgnitionNG");
        java.createArg().setValue(new File(this.getConfiguration().getHome(), "etc").toString() + "/");
        java.addSysproperty(this.getAntUtils().createSysProperty("JO_HOME", this.getConfiguration().getHome()));
        AntContainerExecutorThread joRunner = new AntContainerExecutorThread(java);
        joRunner.start();
    }

    public void doStop(Java java) throws Exception {
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        fileSet.createInclude().setName("lib/*.jar");
        classpath.addFileset(fileSet);
        java.setClassname("com.tagtraum.metaserver.StopServer");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.hostname"));
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        java.createArg().setValue("MetaServer");
        java.execute();
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }
}

