/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.jonas.internal.AbstractJonasInstalledLocalContainer;
import org.codehaus.cargo.container.jonas.internal.Jonas4xAdmin;
import org.codehaus.cargo.container.jonas.internal.Jonas4xAdminImpl;
import org.codehaus.cargo.container.jonas.internal.Jonas4xContainerCapability;

public class Jonas4xInstalledLocalContainer
extends AbstractJonasInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new Jonas4xContainerCapability();
    private Jonas4xAdmin jonasAdmin = new Jonas4xAdminImpl(this);

    public Jonas4xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public void doStart(Java java) {
        this.doAction(java);
        this.doServerAndDomainNameArgs(java);
        java.createArg().setValue("org.objectweb.jonas.server.Server");
        AntContainerExecutorThread jonasRunner = new AntContainerExecutorThread(java);
        jonasRunner.start();
    }

    public void doStop(Java java) {
        java.setFork(true);
        this.doAction(java);
        java.createArg().setValue("org.objectweb.jonas.adm.JonasAdmin");
        this.doServerAndDomainNameParam(java);
        java.createArg().setValue("-s");
        java.reconfigure();
        int returnCode = java.executeJava();
        if (returnCode != 0 && returnCode != 2) {
            throw new IllegalStateException("JonasAdmin stop returned " + returnCode + ", the only values allowed are 0 and 2");
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        long timeout = System.currentTimeMillis() + this.getTimeout();
        while (System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread.sleep failed");
            }
            if (!(waitForStarting ? this.jonasAdmin.isServerRunning("ping", 0) : this.jonasAdmin.isServerRunning("j", 2))) continue;
            return;
        }
        throw new ContainerException("Server.waitForCompletion not finished after " + Long.toString(this.getTimeout()) + " milliseconds!");
    }

    protected void setupExtraSysProps(Java java, Map configuredSysProps) {
        this.addSysProp(java, configuredSysProps, "jonas.default.classloader", "true");
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        this.addSysProp(java, configuredSysProps, "org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        this.addSysProp(java, configuredSysProps, "javax.rmi.CORBA.PortableRemoteObjectClass", "org.objectweb.carol.rmi.multi.MultiPRODelegate");
        this.addSysProp(java, configuredSysProps, "java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
        this.addSysProp(java, configuredSysProps, "javax.rmi.CORBA.UtilClass", "org.objectweb.carol.util.delegate.UtilDelegateImpl");
        this.addSysProp(java, configuredSysProps, "java.rmi.server.RMIClassLoaderSpi", "org.objectweb.jonas.server.RemoteClassLoaderSpi");
    }

    public void doAction(Java java) {
        this.setupSysProps(java);
        java.setClassname("org.objectweb.jonas.server.Bootstrap");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/common/ow_jonas_bootstrap.jar"));
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/commons/jonas/jakarta-commons/commons-logging-api.jar"));
        classpath.createPathElement().setLocation(new File(this.getConfiguration().getHome(), "conf"));
        try {
            this.addToolsJarToClasspath(classpath);
        }
        catch (IOException ex) {
            throw new ContainerException("IOException occured during java command line setup", ex);
        }
        java.setDir(new File(this.getConfiguration().getHome()));
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    public String getId() {
        return "jonas4x";
    }

    public String getName() {
        return "JOnAS 4.x";
    }
}

