/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.jonas.internal.AbstractJonasInstalledLocalContainer;
import org.codehaus.cargo.container.jonas.internal.Jonas5xContainerCapability;
import org.codehaus.cargo.util.AntUtils;

public class Jonas5xInstalledLocalContainer
extends AbstractJonasInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new Jonas5xContainerCapability();

    public Jonas5xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public void doStart(Java java) {
        this.doAction(java);
        this.doServerAndDomainNameArgs(java);
        java.createArg().setValue("-start");
        this.doUsernameAndPasswordArgs(java);
        AntContainerExecutorThread jonasRunner = new AntContainerExecutorThread(java);
        jonasRunner.start();
    }

    public void doStop(Java java) {
        this.doAction(java);
        this.doServerAndDomainNameArgs(java);
        java.createArg().setValue("-stop");
        this.doUsernameAndPasswordArgs(java);
        int returnCode = java.executeJava();
        if (returnCode != 0 && returnCode != 2) {
            throw new ContainerException("JonasAdmin stop returned " + returnCode + ", the only values allowed are 0 and 2");
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (waitForStarting) {
            this.ping(0);
        } else {
            this.ping(1);
        }
    }

    protected void ping(int expectedReturnCode) {
        int returnCode = -1;
        long timeout = System.currentTimeMillis() + this.getTimeout();
        while (System.currentTimeMillis() < timeout) {
            Java ping = (Java)new AntUtils().createAntTask("java");
            ping.setFork(true);
            boolean foundBuildListener = false;
            for (Object listenerObject : ping.getProject().getBuildListeners()) {
                if (!(listenerObject instanceof AntBuildListener)) continue;
                foundBuildListener = true;
                break;
            }
            if (!foundBuildListener) {
                ping.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
            }
            this.doAction(ping);
            this.doServerAndDomainNameArgs(ping);
            ping.createArg().setValue("-ping");
            ping.createArg().setValue("-timeout");
            ping.createArg().setValue("2000");
            this.doUsernameAndPasswordArgs(ping);
            ping.reconfigure();
            ping.setTimeout(new Long(10000L));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new ContainerException("Thread.sleep failed", e);
            }
            returnCode = ping.executeJava();
            if (returnCode != -1 && returnCode != 0 && returnCode != 1 && returnCode != 2) {
                throw new ContainerException("JonasAdmin ping returned " + returnCode + ", the only values allowed are -1, 0, 1 and 2");
            }
            if (returnCode != expectedReturnCode) continue;
            return;
        }
        throw new ContainerException("Server did not reach wanted state after " + Long.toString(this.getTimeout()) + " milliseconds (code " + returnCode + ")");
    }

    protected void setupExtraSysProps(Java java, Map configuredSysProps) {
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        this.addSysProp(java, configuredSysProps, "org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        this.addSysProp(java, configuredSysProps, "com.sun.CORBA.ORBDynamicStubFactoryFactoryClass", "com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl");
    }

    protected void doUsernameAndPasswordArgs(Java java) {
        String username = this.getConfiguration().getPropertyValue("cargo.remote.username");
        String password = this.getConfiguration().getPropertyValue("cargo.remote.password");
        if (username != null && username.trim().length() != 0 && password != null && password.trim().length() != 0) {
            java.createArg().setValue("-username");
            java.createArg().setValue(username);
            java.createArg().setValue("-password");
            java.createArg().setValue(password);
        }
    }

    public void doAction(Java java) {
        this.setupSysProps(java);
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/felix-launcher.jar"));
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/jonas-commands.jar"));
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/jonas-version.jar"));
        classpath.createPathElement().setLocation(new File(this.getConfiguration().getHome(), "conf"));
        try {
            this.addToolsJarToClasspath(classpath);
        }
        catch (IOException ex) {
            throw new ContainerException("IOException occured during java command line setup", ex);
        }
        java.setClassname("org.ow2.jonas.commands.admin.ClientAdmin");
        java.setDir(new File(this.getConfiguration().getHome()));
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    public String getId() {
        return "jonas5x";
    }

    public String getName() {
        return "JOnAS 5.x";
    }
}

