/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import java.io.File;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractJonasInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public AbstractJonasInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public abstract void doStart(Java var1);

    public abstract void doStop(Java var1);

    public void doServerAndDomainNameParam(Java java) {
        String serverName = this.getConfiguration().getPropertyValue("cargo.jonas.server.name");
        if (serverName != null && serverName.trim().length() != 0) {
            java.createArg().setValue("-n");
            java.createArg().setValue(serverName);
        }
        this.doDomainNameArgs(java);
    }

    public void doServerAndDomainNameArgs(Java java) {
        String serverName = this.getConfiguration().getPropertyValue("cargo.jonas.server.name");
        if (serverName == null || serverName.trim().length() == 0) {
            serverName = "jonas";
        }
        java.createJvmarg().setValue("-Djonas.name=" + serverName);
        this.doDomainNameArgs(java);
    }

    private void doDomainNameArgs(Java java) {
        String domainName = this.getConfiguration().getPropertyValue("cargo.jonas.domain.name");
        if (domainName == null || domainName.trim().length() == 0) {
            domainName = "jonas";
        }
        java.createJvmarg().setValue("-Ddomain.name=" + domainName);
    }

    public void setupSysProps(Java java) {
        Map configuredSysProps = this.getSystemProperties();
        this.addSysProp(java, configuredSysProps, "install.root", new File(this.getHome()).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "jonas.root", new File(this.getHome()).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "jonas.base", new File(this.getConfiguration().getHome()).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "java.endorsed.dirs", new File(this.getFileHandler().append(this.getHome(), "lib/endorsed")).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "java.security.policy", new File(this.getFileHandler().append(this.getConfiguration().getHome(), "conf/java.policy")).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "java.security.auth.login.config", new File(this.getFileHandler().append(this.getConfiguration().getHome(), "conf/jaas.config")).getAbsolutePath().replace(File.separatorChar, '/'));
        this.addSysProp(java, configuredSysProps, "jonas.classpath", "");
        this.addSysProp(java, configuredSysProps, "java.awt.headless", "true");
        this.setupExtraSysProps(java, configuredSysProps);
    }

    protected abstract void setupExtraSysProps(Java var1, Map var2);

    public void addSysProp(Java java, Map configuredSysProps, String name, String value) {
        if (configuredSysProps == null || !configuredSysProps.containsKey(name)) {
            java.addSysproperty(this.getAntUtils().createSysProperty(name, value));
        }
    }
}

