/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.jonas.internal.MBeanServerConnectionFactory;

public class JSR160MBeanServerConnectionFactory
implements MBeanServerConnectionFactory {
    private static final String DEFAULT_URI = "service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private JMXConnector connector;

    public MBeanServerConnection getServerConnection(RuntimeConfiguration configuration) throws IOException {
        String username = configuration.getPropertyValue("cargo.remote.username");
        String password = configuration.getPropertyValue("cargo.remote.password");
        String jmxRemoteURL = configuration.getPropertyValue("cargo.remote.uri");
        if (jmxRemoteURL == null || jmxRemoteURL.trim().length() == 0) {
            String hostname;
            jmxRemoteURL = DEFAULT_URI;
            String port = configuration.getPropertyValue("cargo.rmi.port");
            if (port != null) {
                jmxRemoteURL = jmxRemoteURL.replace("1099", port);
            }
            if ((hostname = configuration.getPropertyValue("cargo.hostname")) != null) {
                jmxRemoteURL = jmxRemoteURL.replace("localhost", hostname);
            }
        }
        HashMap<String, Object> environment = new HashMap<String, Object>();
        if (username != null && username.trim().length() > 0 && password != null && password.trim().length() > 0) {
            String[] credentials = new String[]{username, password};
            environment.put("jmx.remote.credentials", credentials);
        }
        if (!environment.containsKey("jmx.remote.protocol.provider.class.loader")) {
            environment.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        }
        JMXServiceURL address = new JMXServiceURL(jmxRemoteURL);
        this.connector = JMXConnectorFactory.connect(address, environment);
        MBeanServerConnection mbsc = this.connector.getMBeanServerConnection();
        return mbsc;
    }

    public void destroy() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
            this.connector = null;
        }
    }
}

