/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jrun;

import java.io.File;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.property.User;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JRun4xFilterChain
extends FilterChain {
    private InstalledLocalContainer jrunContainer;
    private LocalConfiguration configuration;

    public JRun4xFilterChain(LocalContainer jrunContainer) {
        this.jrunContainer = (InstalledLocalContainer)jrunContainer;
        this.configuration = jrunContainer.getConfiguration();
        this.init();
    }

    private void init() {
        ReplaceTokens jrunTokens = new ReplaceTokens();
        jrunTokens.addConfiguredToken(this.createServerNameToken());
        jrunTokens.addConfiguredToken(this.createPortToken());
        jrunTokens.addConfiguredToken(this.createLoggingToken());
        jrunTokens.addConfiguredToken(this.createUserToken());
        jrunTokens.addConfiguredToken(this.createRmiPortToken());
        this.addReplaceTokens(jrunTokens);
        this.addReplaceTokens(this.createJvmConfigTokens());
    }

    private ReplaceTokens.Token createServerNameToken() {
        String serverName = this.getPropertyValue("cargo.jrun.server.name");
        ReplaceTokens.Token tokenServerName = new ReplaceTokens.Token();
        tokenServerName.setKey("cargo.jrun.server.name");
        tokenServerName.setValue(serverName);
        return tokenServerName;
    }

    private ReplaceTokens.Token createPortToken() {
        String port = this.getPropertyValue("cargo.servlet.port");
        if (port == null) {
            port = "8100";
        }
        ReplaceTokens.Token tokenPort = new ReplaceTokens.Token();
        tokenPort.setKey("cargo.servlet.port");
        tokenPort.setValue(port);
        return tokenPort;
    }

    private ReplaceTokens.Token createLoggingToken() {
        String errorEnabled = "true";
        String warningEnabled = "true";
        String infoEnabled = "true";
        String debugEnabled = "false";
        String cargoLogLevel = this.getPropertyValue("cargo.logging");
        if ("low".equalsIgnoreCase(cargoLogLevel)) {
            warningEnabled = "false";
        }
        if ("high".equalsIgnoreCase(cargoLogLevel)) {
            debugEnabled = "true";
        }
        StringBuilder logging = new StringBuilder();
        logging.append("<!-- cargo logging level: " + cargoLogLevel + " --> \n");
        logging.append("<attribute name=\"errorEnabled\">" + errorEnabled + "</attribute>\n");
        logging.append("<attribute name=\"warningEnabled\">" + warningEnabled + "</attribute>\n");
        logging.append("<attribute name=\"infoEnabled\">" + infoEnabled + "</attribute>\n");
        logging.append("<attribute name=\"debugEnabled\">" + debugEnabled + "</attribute>\n");
        ReplaceTokens.Token tokenLogging = new ReplaceTokens.Token();
        tokenLogging.setKey("cargo.jrun.logging");
        tokenLogging.setValue(logging.toString());
        return tokenLogging;
    }

    private ReplaceTokens createJvmConfigTokens() {
        ReplaceTokens.Token tokenJavaHome = this.createJavaHomeToken();
        ReplaceTokens.Token tokenClassPath = this.createClassPathToken();
        ReplaceTokens.Token tokenVmArgs = this.createVmArgsToken();
        ReplaceTokens replaceConfig = new ReplaceTokens();
        replaceConfig.addConfiguredToken(tokenJavaHome);
        replaceConfig.addConfiguredToken(tokenClassPath);
        replaceConfig.addConfiguredToken(tokenVmArgs);
        return replaceConfig;
    }

    private ReplaceTokens.Token createJavaHomeToken() {
        String javaHome = this.getPropertyValue("cargo.java.home");
        ReplaceTokens.Token tokenJavaHome = new ReplaceTokens.Token();
        tokenJavaHome.setKey("jrun.java.home");
        tokenJavaHome.setValue(javaHome.replace('\\', '/'));
        return tokenJavaHome;
    }

    private ReplaceTokens.Token createClassPathToken() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jrunContainer.getHome() + "/servers/lib,");
        sb.append(this.jrunContainer.getHome() + "/lib/macromedia_drivers.jar,");
        sb.append(this.jrunContainer.getHome() + "/lib/webservices.jar");
        if (this.jrunContainer.getExtraClasspath().length > 0) {
            sb.append(",");
            String[] extraPaths = this.jrunContainer.getExtraClasspath();
            for (int i = 0; i < extraPaths.length; ++i) {
                sb.append(extraPaths[i].replace('\\', '/'));
                if (i >= extraPaths.length - 1) continue;
                sb.append(",");
            }
        }
        ReplaceTokens.Token tokenClasspath = new ReplaceTokens.Token();
        tokenClasspath.setKey("cargo.jrun4x.classpath");
        tokenClasspath.setValue(sb.toString());
        return tokenClasspath;
    }

    private ReplaceTokens.Token createVmArgsToken() {
        StringBuilder jvmArgs = new StringBuilder();
        File hotFixJar = new File(this.jrunContainer.getHome() + "/servers/lib/54101.jar");
        if (hotFixJar.exists()) {
            jvmArgs.append("-Djava.rmi.server.RMIClassLoaderSpi=jrunx.util.JRunRMIClassLoaderSpi ");
        }
        jvmArgs.append("-Dsun.io.useCanonCaches=false ");
        jvmArgs.append("-Djmx.invoke.getters=true ");
        jvmArgs.append("-Xms32m ");
        jvmArgs.append("-Xmx128m ");
        ReplaceTokens.Token tokenVmArgs = new ReplaceTokens.Token();
        tokenVmArgs.setKey("jrun.jvm.args");
        tokenVmArgs.setValue(jvmArgs.toString());
        return tokenVmArgs;
    }

    protected ReplaceTokens.Token createUserToken() {
        StringBuilder token = new StringBuilder();
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            for (User user : User.parseUsers(this.getPropertyValue("cargo.servlet.users"))) {
                Element userElement = DocumentHelper.createDocument().addElement("user");
                userElement.addElement("user-name").setText(user.getName());
                userElement.addElement("password").setText(user.getPassword());
                token.append(userElement.asXML());
                for (String role : user.getRoles()) {
                    Element roleElement = DocumentHelper.createDocument().addElement("role");
                    roleElement.addElement("role-name").setText(role);
                    roleElement.addElement("user-name").setText(user.getName());
                    token.append(roleElement.asXML());
                }
            }
        }
        ReplaceTokens.Token tokenUsers = new ReplaceTokens.Token();
        tokenUsers.setKey("jrun.users");
        tokenUsers.setValue(token.toString());
        return tokenUsers;
    }

    private ReplaceTokens.Token createRmiPortToken() {
        if (this.getPropertyValue("cargo.rmi.port") == null) {
            this.configuration.setProperty("cargo.rmi.port", "2999");
        }
        String rmiPort = this.getPropertyValue("cargo.rmi.port");
        ReplaceTokens.Token tokenRmiPort = new ReplaceTokens.Token();
        tokenRmiPort.setKey("cargo.rmi.port");
        tokenRmiPort.setValue(rmiPort);
        return tokenRmiPort;
    }

    private String getPropertyValue(String propertyName) {
        return this.configuration.getPropertyValue(propertyName);
    }
}

