/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion.internal;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractOc4j10xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private ContainerCapability capability = new J2EEContainerCapability();

    public AbstractOc4j10xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void doStop(Java java) {
        File adminClientJar = new File(this.getHome() + "/j2ee/home/admin_client.jar");
        java.setJar(adminClientJar);
        String shutdownURL = "deployer:oc4j:" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.rmi.port");
        this.getLogger().debug("Shutdown URL [" + shutdownURL + "]", this.getClass().getName());
        java.createArg().setValue(shutdownURL);
        java.createArg().setValue("oc4jadmin");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.oc4j.admin.pwd"));
        java.createArg().setValue("-shutdown");
        AntContainerExecutorThread orionRunner = new AntContainerExecutorThread(java);
        orionRunner.start();
    }

    public final void doStart(Java java) throws Exception {
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        Iterator i = this.getContainerClasspathIncludes().iterator();
        while (i.hasNext()) {
            fileSet.createInclude().setName((String)i.next());
        }
        classpath.addFileset(fileSet);
        this.addToolsJarToClasspath(classpath);
        java.setClassname(this.getStartClassname());
        java.createArg().setValue("-config");
        java.createArg().setFile(new File(this.getConfiguration().getHome(), "config/server.xml"));
        java.createArg().setValue("-userThreads");
        AntContainerExecutorThread oc4jRunner = new AntContainerExecutorThread(java);
        oc4jRunner.start();
    }

    protected abstract String getStartClassname();

    protected abstract String getStopClassname();

    protected abstract Set getContainerClasspathIncludes();
}

