/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion.internal;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractOrionInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private ContainerCapability capability = new J2EEContainerCapability();

    public AbstractOrionInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void doStop(Java java) {
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        fileSet.createInclude().setName(this.getContainerClasspathIncludes());
        classpath.addFileset(fileSet);
        java.setClassname(this.getStopClassname());
        String shutdownURL = "ormi://" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.rmi.port") + "/";
        this.getLogger().debug("Shutdown URL [" + shutdownURL + "]", this.getClass().getName());
        java.createArg().setValue(shutdownURL);
        java.createArg().setValue("cargo");
        java.createArg().setValue("cargo");
        java.createArg().setValue("-shutdown");
        AntContainerExecutorThread orionRunner = new AntContainerExecutorThread(java);
        orionRunner.start();
    }

    public final void doStart(Java java) throws Exception {
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        fileSet.createInclude().setName(this.getContainerClasspathIncludes());
        classpath.addFileset(fileSet);
        this.addToolsJarToClasspath(classpath);
        java.setClassname(this.getStartClassname());
        java.createArg().setValue("-config");
        java.createArg().setFile(new File(this.getConfiguration().getHome(), "conf/server.xml"));
        this.addToolsJarToClasspath(classpath);
        AntContainerExecutorThread orionRunner = new AntContainerExecutorThread(java);
        orionRunner.start();
    }

    protected abstract String getStartClassname();

    protected abstract String getStopClassname();

    protected abstract String getContainerClasspathIncludes();
}

