/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion.internal;

import java.util.Iterator;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractConfigurationBuilder;

public class OrionConfigurationBuilder
extends AbstractConfigurationBuilder {
    public static final String RESOURCE_CONFIGURATION_UNSUPPORTED = "Orion does not support configuration of arbitrary resources into the JNDI tree.";
    private DataSource ds;
    private StringBuffer buffer;

    private void addBackingDataSourceWithImplementationClass(String className) {
        this.startDataSourceTag();
        this.setImplementationClassAndJndiContext(className, "Provided");
        this.addVendorConnectionDataAndCloseTag();
    }

    private void addVendorConnectionDataAndCloseTag() {
        this.addCommonConnectionAttributes();
        this.endDataSourceTag();
        this.addNestedDriverPropertyTags();
        this.closeDataSourceTag();
    }

    private void addCMTDataSourceTag() {
        this.startDataSourceTag();
        this.addCMTDataSourceAndLinkToXa();
        this.addIdAndJndiLocationAttributes();
        this.endDataSourceTag();
        this.closeDataSourceTag();
    }

    private void closeDataSourceTag() {
        this.buffer.append("</data-source>\n");
    }

    private void setImplementationClassAndJndiContext(String className, String suffix) {
        this.buffer.append("    name='").append(this.ds.getId()).append(suffix).append("' \n");
        this.buffer.append("    connection-driver='" + className + "'\n");
        this.buffer.append("    class='" + className + "'\n");
        this.buffer.append("    location='").append(this.ds.getJndiLocation()).append(suffix).append("' \n");
    }

    private void endDataSourceTag() {
        this.buffer.append(" >\n");
    }

    private void startDataSourceTag() {
        this.buffer.append("<data-source \n");
    }

    private void addCMTDataSourceAndLinkToXa() {
        this.buffer.append("    class='com.evermind.sql.OrionCMTDataSource' \n ");
        this.buffer.append("    xa-source-location='").append(this.ds.getJndiLocation()).append("Provided").append("' \n");
    }

    private void addDriverAttributes() {
        this.buffer.append("    class='com.evermind.sql.DriverManagerDataSource' \n ");
        this.buffer.append("    connection-driver='" + this.ds.getDriverClass() + "'\n");
    }

    private void addIdAndJndiLocationAttributes() {
        this.buffer.append("    name='").append(this.ds.getId()).append("' \n");
        this.buffer.append("    location='").append(this.ds.getJndiLocation()).append("' \n");
    }

    private void addIdAndExtraLocationAttributes(String location, String ejbLocation, String xaLocation) {
        this.buffer.append("    name='").append(this.ds.getId()).append("' \n");
        this.buffer.append("    location='").append(location).append("' \n");
        this.buffer.append("    ejb-location='").append(ejbLocation).append("' \n");
        this.buffer.append("    xa-location='").append(xaLocation).append("' \n");
    }

    private void addCommonConnectionAttributes() {
        this.buffer.append("    username='").append(this.ds.getUsername()).append("' \n");
        this.buffer.append("    password='").append(this.ds.getPassword()).append("' \n");
        if (this.ds.getUrl() != null) {
            this.buffer.append("    url='" + this.ds.getUrl()).append("' \n");
        }
        this.buffer.append("    inactivity-timeout='30'");
    }

    private void addNestedDriverPropertyTags() {
        if (this.ds.getConnectionProperties() != null && this.ds.getConnectionProperties().size() != 0) {
            Iterator<Object> i = this.ds.getConnectionProperties().keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                this.buffer.append("      <property name=\"").append(key);
                this.buffer.append("\" value=\"").append(this.ds.getConnectionProperties().getProperty(key)).append("\" />\n");
            }
        }
    }

    public String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource ds) {
        this.ds = ds;
        this.buffer = new StringBuffer();
        this.startDataSourceTag();
        this.addDriverAttributes();
        this.addIdAndExtraLocationAttributes(ds.getJndiLocation(), ds.getJndiLocation() + "local", ds.getJndiLocation() + "xa");
        this.addVendorConnectionDataAndCloseTag();
        return this.buffer.toString();
    }

    public String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource ds) {
        this.ds = ds;
        this.buffer = new StringBuffer();
        this.startDataSourceTag();
        this.addDriverAttributes();
        this.addIdAndExtraLocationAttributes(ds.getJndiLocation() + "notx", ds.getJndiLocation(), ds.getJndiLocation() + "xa");
        this.addVendorConnectionDataAndCloseTag();
        return this.buffer.toString();
    }

    public String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource ds) {
        this.ds = ds;
        this.buffer = new StringBuffer();
        this.startDataSourceTag();
        this.addDriverAttributes();
        this.addIdAndExtraLocationAttributes(ds.getJndiLocation() + "notx", ds.getJndiLocation() + "local", ds.getJndiLocation());
        this.addVendorConnectionDataAndCloseTag();
        return this.buffer.toString();
    }

    public String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource ds) {
        this.ds = ds;
        this.buffer = new StringBuffer();
        this.addBackingDataSourceWithImplementationClass(ds.getDriverClass());
        this.addCMTDataSourceTag();
        return this.buffer.toString();
    }

    public String toConfigurationEntry(Resource resource) {
        throw new UnsupportedOperationException(RESOURCE_CONFIGURATION_UNSUPPORTED);
    }
}

