/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractInstalledLocalContainer
extends AbstractLocalContainer
implements InstalledLocalContainer {
    private Map systemProperties;
    private List extraClasspath;
    private List sharedClasspath;
    private String home;
    private JdkUtils jdkUtils = new JdkUtils();
    private AntUtils antUtils = new AntUtils();
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils = new ResourceUtils();

    public AbstractInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.httpUtils = new HttpUtils();
        this.extraClasspath = new ArrayList();
        this.sharedClasspath = new ArrayList();
        this.systemProperties = new HashMap();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.resourceUtils.setLogger(logger);
        this.httpUtils.setLogger(logger);
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final JdkUtils getJdkUtils() {
        return this.jdkUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    public final void setHome(String home) {
        this.home = home;
    }

    public void setSystemProperties(Map properties) {
        HashMap props = new HashMap();
        props.putAll(properties);
        this.systemProperties = props;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath.clear();
        this.extraClasspath.addAll(Arrays.asList(classpath));
    }

    public String[] getExtraClasspath() {
        return this.extraClasspath.toArray(new String[0]);
    }

    public void setSharedClasspath(String[] classpath) {
        this.sharedClasspath.clear();
        this.sharedClasspath.addAll(Arrays.asList(classpath));
    }

    public String[] getSharedClasspath() {
        return this.sharedClasspath.toArray(new String[0]);
    }

    public final String getHome() {
        return this.home;
    }

    protected abstract void doStart(Java var1) throws Exception;

    protected abstract void doStop(Java var1) throws Exception;

    protected final void startInternal() throws Exception {
        Java java = this.createJavaTask();
        this.addMemoryArguments(java);
        this.doStart(java);
    }

    protected final void stopInternal() throws Exception {
        this.doStop(this.createJavaTask());
    }

    protected Java createJavaTask() {
        Java java;
        boolean isSsh;
        boolean bl = isSsh = this.getConfiguration().getPropertyValue("cargo.ssh.host") != null;
        if (isSsh) {
            java = (Java)this.getAntUtils().createAntTask("sshjava");
            this.addSshProperties(java);
        } else {
            java = (Java)this.getAntUtils().createAntTask("java");
        }
        java.setFork(true);
        if (this.getOutput() != null) {
            File outputFile = new File(this.getOutput());
            outputFile.getAbsoluteFile().getParentFile().mkdirs();
            java.setOutput(outputFile);
            java.setAppend(this.isAppend());
        }
        boolean foundBuildListener = false;
        for (Object listenerObject : java.getProject().getBuildListeners()) {
            if (!(listenerObject instanceof AntBuildListener)) continue;
            foundBuildListener = true;
            break;
        }
        if (!foundBuildListener) {
            java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
        }
        this.setJvmToLaunchContainerIn(java);
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        this.addRuntimeArgs(java);
        this.addJvmArgs(java);
        return java;
    }

    private void addSshProperties(Java java) {
        java.setDir(new File(this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome())));
        if (this.getConfiguration().getDeployables() != null) {
            for (Object object : this.getConfiguration().getDeployables()) {
                Deployable toDeploy = (Deployable)object;
                Environment.Variable deployable = new Environment.Variable();
                deployable.setKey("sshjava.shift." + this.getFileHandler().getAbsolutePath(toDeploy.getFile()));
                deployable.setValue("deployables/" + new File(toDeploy.getFile()).getName());
                java.addSysproperty(deployable);
            }
        }
        if (this.getHome() != null) {
            Environment.Variable home = new Environment.Variable();
            home.setKey("sshjava.shift." + this.getFileHandler().getAbsolutePath(this.getHome()));
            home.setValue("containers/" + this.getId());
            java.addSysproperty(home);
        }
        Properties properties = new Properties();
        properties.put("sshjava.username", "cargo.ssh.username");
        properties.put("sshjava.host", "cargo.ssh.host");
        properties.put("sshjava.password", "cargo.ssh.password");
        properties.put("sshjava.keyfile", "cargo.ssh.keyfile");
        properties.put("sshjava.remotebase", "cargo.ssh.remotebase");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Environment.Variable var = new Environment.Variable();
            var.setKey(entry.getKey().toString());
            var.setValue(this.getConfiguration().getPropertyValue(entry.getValue().toString()));
            java.addSysproperty(var);
        }
    }

    protected void setJvmToLaunchContainerIn(Java java) {
        String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
        if (javaHome != null) {
            String binDir = this.getFileHandler().append(javaHome, "bin");
            String javaPath = this.getFileHandler().append(binDir, "java");
            if (Os.isFamily((String)"windows")) {
                javaPath = javaPath + ".exe";
            }
            java.setJvm(javaPath);
        }
    }

    private void addSystemProperties(Java java) {
        for (String key : this.getSystemProperties().keySet()) {
            java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getSystemProperties().get(key)));
        }
    }

    protected final void addToolsJarToClasspath(Path classpath) throws FileNotFoundException {
        if (!this.getJdkUtils().isOSX()) {
            String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
            if (javaHome == null) {
                classpath.createPathElement().setLocation(this.getJdkUtils().getToolsJar());
            } else {
                if (javaHome.contains("jre")) {
                    javaHome = this.getFileHandler().getParent(javaHome);
                }
                String libDir = this.getFileHandler().append(javaHome, "lib");
                classpath.createPathElement().setLocation(new File(libDir, "tools.jar"));
            }
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.extraClasspath.size() > 0) {
            Path path = new Path(this.getAntUtils().createProject());
            Iterator entries = this.extraClasspath.iterator();
            while (entries.hasNext()) {
                Path pathElement = new Path(this.getAntUtils().createProject(), (String)entries.next());
                path.addExisting(pathElement);
                this.getLogger().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    private void addRuntimeArgs(Java javacommand) {
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            String[] arguments;
            for (String argument : arguments = runtimeArgs.split(" ")) {
                javacommand.createArg().setValue(argument);
            }
        }
    }

    private void addJvmArgs(Java javacommand) {
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            jvmargs = jvmargs.replace("\n", " ");
            jvmargs = jvmargs.replace("\r", " ");
            jvmargs = jvmargs.replace("\t", " ");
            javacommand.createJvmarg().setLine(jvmargs);
        }
    }

    protected void addMemoryArguments(Java java) {
        String jvmArgs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmArgs == null || !jvmArgs.contains("-Xms")) {
            java.createJvmarg().setValue("-Xms128m");
        }
        if (jvmArgs == null || !jvmArgs.contains("-Xmx")) {
            java.createJvmarg().setValue("-Xmx512m");
        }
        if (jvmArgs == null || !jvmArgs.contains("-XX:PermSize")) {
            java.createJvmarg().setValue("-XX:PermSize=48m");
        }
        if (jvmArgs == null || !jvmArgs.contains("-XX:MaxPermSize")) {
            java.createJvmarg().setValue("-XX:MaxPermSize=128m");
        }
    }

    protected void verify() {
        super.verify();
        this.verifyHome();
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getFileHandler().isDirectory(this.getHome())) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory. It must point " + "to the container home directory.");
        }
    }

    public ContainerType getType() {
        return ContainerType.INSTALLED;
    }

    public void addExtraClasspath(String location) {
        this.ifPresentAddPathToList(location, this.extraClasspath);
    }

    public void addSharedClasspath(String location) {
        this.ifPresentAddPathToList(location, this.sharedClasspath);
    }

    public void ifPresentAddPathToList(String location, List list) {
        if (location == null || !this.getFileHandler().exists(location)) {
            throw new IllegalArgumentException("Invalid file path: " + location);
        }
        list.add(location);
    }
}

