/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;

public class WebLogicCopyingInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public WebLogicCopyingInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        WebLogicLocalContainer container = (WebLogicLocalContainer)this.getContainer();
        return new File(container.getConfiguration().getHome(), container.getAutoDeployDirectory()).toString();
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        this.getFileHandler().copyDirectory(war.getFile(), this.getFileHandler().append(deployableDir, war.getContext() + ".war"));
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void undeploy(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            super.undeploy(deployable);
            return;
        }
        WAR war = (WAR)deployable;
        String fileName = this.getFileHandler().append(this.getDeployableDir(), war.getContext() + ".war");
        if (this.getFileHandler().exists(fileName)) {
            this.getLogger().info("Undeploying [" + fileName + "]...", this.getClass().getName());
            this.getFileHandler().delete(fileName);
        }
    }
}

