/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.io.IOException;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogic8xConfigXmlInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;
import org.codehaus.cargo.container.weblogic.internal.WebLogicExistingLocalConfigurationCapability;

public class WebLogicExistingLocalConfiguration
extends AbstractExistingLocalConfiguration
implements WebLogicConfiguration {
    private static ConfigurationCapability capability = new WebLogicExistingLocalConfigurationCapability();

    public WebLogicExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupDeployables((WebLogicLocalContainer)container);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public String toString() {
        return "WebLogic Existing Configuration";
    }

    protected void setupDeployables(WebLogicLocalContainer container) throws IOException {
        WebLogicLocalContainer weblogicContainer = container;
        File deployDir = new File(this.getDomainHome(), weblogicContainer.getAutoDeployDirectory());
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        WebLogic8xConfigXmlInstalledLocalDeployer deployer = new WebLogic8xConfigXmlInstalledLocalDeployer((InstalledLocalContainer)((Object)container));
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public String getDomainHome() {
        return this.getHome();
    }
}

