/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Logger;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

public class Jonas {
    public static final String JAR_NAME = "configurator-impl.jar";
    protected int majorVersion;
    protected JonasConfigurator jonasConfigurator;
    private static Logger logger = Logger.getLogger(Jonas.class.getName());

    public Jonas(String jonasRoot) {
        try {
            URL antTasks = new File(jonasRoot + File.separator + "lib" + File.separator + "common" + File.separator + "ow_jonas_ant.jar").toURI().toURL();
            URL owJonas = new File(jonasRoot + File.separator + "lib" + File.separator + "commons" + File.separator + "jonas" + File.separator + "ow_jonas.jar").toURI().toURL();
            logger.finest("Configuring jonasRoot : " + jonasRoot + " using ant library on URL : " + antTasks);
            URLClassLoader search = new URLClassLoader(new URL[]{antTasks}, null);
            if (search.getResource("org/ow2/jonas/ant/JOnASBaseTask.class") != null) {
                this.majorVersion = 5;
            } else if (search.getResource("org/objectweb/jonas/ant/JOnASBaseTask.class") != null) {
                this.majorVersion = 4;
            } else {
                throw new Exception("Not a JOnAS 4 or JOnAS 5 ANT tasks JAR file");
            }
            InputStream is = this.getClass().getResourceAsStream(JAR_NAME);
            if (is == null) {
                throw new IllegalStateException("Cannot find JAR file configurator-impl.jar in package " + this.getClass().getPackage().getName());
            }
            File temp = File.createTempFile(Jonas.class.getName(), ".jar");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            int length = is.available();
            while (length > 0) {
                byte[] b = new byte[length];
                length = is.read(b);
                fos.write(b, 0, length);
                length = is.available();
            }
            fos.close();
            URLClassLoader instanciate = new URLClassLoader(new URL[]{antTasks, owJonas, temp.toURI().toURL()}, this.getClass().getClassLoader());
            Class<JonasConfigurator> instance = instanciate.loadClass("org.ow2.jonas.tools.configurator.impl.Jonas" + this.majorVersion).asSubclass(JonasConfigurator.class);
            this.jonasConfigurator = instance.newInstance();
            instance.getMethod("setJonasRoot", String.class).invoke((Object)this.jonasConfigurator, jonasRoot);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The file \"" + jonasRoot + "\" doesn't contain any JOnAS ANT tasks JAR file", e);
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public JonasConfigurator getJonasConfigurator() {
        return this.jonasConfigurator;
    }
}

