/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven2.Deployable;
import org.codehaus.cargo.maven2.util.CargoProject;

public class Configuration {
    private String type = ConfigurationType.STANDALONE.getType();
    private Class implementation;
    private File dir;
    private Map properties;
    private Deployable[] deployables;

    public ConfigurationType getType() {
        return ConfigurationType.toType((String)this.type);
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Deployable[] getDeployables() {
        return this.deployables;
    }

    public void setDeployables(Deployable[] deployables) {
        this.deployables = deployables;
    }

    public Class getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Class implementation) {
        this.implementation = implementation;
    }

    public org.codehaus.cargo.container.configuration.Configuration createConfiguration(String containerId, CargoProject project) throws MojoExecutionException {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getImplementation() != null) {
            factory.registerConfiguration(containerId, this.getType(), this.getImplementation());
        }
        org.codehaus.cargo.container.configuration.Configuration configuration = this.getDir() == null ? factory.createConfiguration(containerId, this.getType()) : factory.createConfiguration(containerId, this.getType(), this.getDir());
        if (this.getProperties() != null) {
            Iterator itProperties = this.getProperties().keySet().iterator();
            while (itProperties.hasNext()) {
                String propertyName = (String)itProperties.next();
                configuration.setProperty(propertyName, (String)this.getProperties().get(propertyName));
            }
        }
        if (configuration instanceof LocalConfiguration && this.getDeployables() != null) {
            this.addStaticDeployables(containerId, (LocalConfiguration)configuration, project);
        }
        return configuration;
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (int i = 0; i < this.getDeployables().length; ++i) {
            configuration.addDeployable(this.getDeployables()[i].createDeployable(containerId, project));
        }
    }
}

