/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.maven2.ZipUrlInstaller;
import org.codehaus.cargo.util.monitor.Monitor;

public class Container {
    private String containerId;
    private Class implementation;
    private File home;
    private File output;
    private ZipUrlInstaller zipUrlInstaller;
    private boolean append;
    private File log;
    private String type = ContainerType.LOCAL.getType();

    public ContainerType getType() {
        return ContainerType.toType((String)this.type);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public File getOutput() {
        return this.output;
    }

    public ZipUrlInstaller getZipUrlInstaller() {
        return this.zipUrlInstaller;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public File getLog() {
        return this.log;
    }

    public Class getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Class implementation) {
        this.implementation = implementation;
    }

    public org.codehaus.cargo.container.Container createContainer(Configuration configuration, Monitor monitor) throws MojoExecutionException {
        org.codehaus.cargo.container.Container container;
        DefaultContainerFactory factory = new DefaultContainerFactory();
        if (this.getImplementation() != null) {
            factory.registerContainer(this.getContainerId(), this.getType(), this.getImplementation());
        }
        if ((container = factory.createContainer(this.getContainerId(), this.getType(), configuration)) instanceof LocalContainer) {
            this.setupHome(container);
        }
        this.setupMonitor(container, monitor);
        return container;
    }

    private void setupHome(org.codehaus.cargo.container.Container container) {
        if (this.getHome() != null) {
            ((LocalContainer)container).setHome(this.getHome());
        } else if (this.getZipUrlInstaller() != null) {
            ZipURLInstaller installer = this.getZipUrlInstaller().createInstaller();
            if (this.getLog() != null) {
                installer.setMonitor(container.getMonitor());
            }
            installer.install();
            ((LocalContainer)container).setHome(installer.getHome());
        }
    }

    private void setupMonitor(org.codehaus.cargo.container.Container container, Monitor monitor) {
        container.setMonitor(monitor);
        if (container instanceof LocalContainer) {
            ((LocalContainer)container).getConfiguration().setMonitor(monitor);
        } else {
            ((RemoteContainer)container).getConfiguration().setMonitor(monitor);
        }
    }
}

