/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.maven2.AbstractDeployerMojo;

public class DeployMojo
extends AbstractDeployerMojo {
    public void execute() throws MojoExecutionException {
        super.execute();
        this.deploy();
    }

    private void deploy() throws MojoExecutionException {
        Container container = this.createContainer();
        Deployer deployer = this.createDeployer(container);
        this.getLog().debug((CharSequence)("Deploying into [" + container.getName() + "]..."));
        if (this.getDeployerElement() != null) {
            for (int i = 0; i < this.getDeployerElement().getDeployables().length; ++i) {
                Deployable deployable = this.getDeployerElement().getDeployables()[i].createDeployable(container.getId(), this.getCargoProject());
                URL pingURL = this.getDeployerElement().getDeployables()[i].getPingURL();
                this.deploySingleDeployable(deployer, deployable, pingURL);
            }
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getDeployerElement() == null || this.getDeployerElement().getDeployables() == null || !this.containsAutoDeployable(this.getDeployerElement().getDeployables()))) {
            this.deploySingleDeployable(deployer, this.createAutoDeployDeployable(container), null);
        }
    }

    private void deploySingleDeployable(Deployer deployer, Deployable deployable, URL pingURL) {
        this.getLog().debug((CharSequence)("Deploying [" + deployable.getFile() + "]" + (pingURL == null ? "..." : " using ping URL [" + pingURL + "]")));
        if (pingURL != null) {
            deployer.deploy(deployable, this.createDeployableMonitor(pingURL, deployable));
        } else {
            deployer.deploy(deployable);
        }
    }

    private DeployableMonitor createDeployableMonitor(URL pingURL, Deployable deployable) {
        URLDeployableMonitor monitor = new URLDeployableMonitor(pingURL);
        DeployerListener listener = new DeployerListener(deployable);
        monitor.registerListener((DeployableMonitorListener)listener);
        return monitor;
    }

    public class DeployerListener
    implements DeployableMonitorListener {
        private Deployable deployable;

        public DeployerListener(Deployable deployable) {
            this.deployable = deployable;
        }

        public void deployed() {
            DeployMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile().getPath() + "] deployed."));
        }

        public void undeployed() {
            DeployMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile().getPath() + "] not deployed yet."));
        }
    }
}

