/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.maven2.AbstractDeployerMojo;

public class UndeployMojo
extends AbstractDeployerMojo {
    public void execute() throws MojoExecutionException {
        super.execute();
        this.undeploy();
    }

    private void undeploy() throws MojoExecutionException {
        Container container = this.createContainer();
        Deployer deployer = this.createDeployer(container);
        this.getLog().debug((CharSequence)("Undeploying from [" + container.getName() + "]..."));
        for (int i = 0; i < this.getDeployerElement().getDeployables().length; ++i) {
            Deployable deployable = this.getDeployerElement().getDeployables()[i].createDeployable(container.getId(), this.getCargoProject());
            this.undeploySingleDeployable(deployer, deployable);
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getDeployerElement() == null || this.getDeployerElement().getDeployables() == null || !this.containsAutoDeployable(this.getDeployerElement().getDeployables()))) {
            this.undeploySingleDeployable(deployer, this.createAutoDeployDeployable(container));
        }
    }

    private void undeploySingleDeployable(Deployer deployer, Deployable deployable) {
        this.getLog().debug((CharSequence)("Undeploying [" + deployable.getFile() + "]..."));
        deployer.undeploy(deployable);
    }
}

