/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.configuration.Resource;
import org.codehaus.cargo.maven2.util.CargoProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private String type = ConfigurationType.STANDALONE.getType();
    private String implementation;
    private String home;
    private Map<String, String> properties;
    private File propertiesFile;
    private FileConfig[] fileConfigs;
    private FileConfig[] configfiles;
    private Resource[] resources;

    public ConfigurationType getType() {
        return ConfigurationType.toType((String)this.type);
    }

    public void setType(ConfigurationType type) {
        this.type = type.getType();
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public FileConfig[] getConfigfiles() {
        return this.configfiles;
    }

    public void setConfigfiles(FileConfig[] configfiles) {
        this.configfiles = configfiles;
    }

    public FileConfig[] getFiles() {
        return this.fileConfigs;
    }

    public void setFiles(FileConfig[] fileConfigs) {
        this.fileConfigs = fileConfigs;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] rlist) {
        this.resources = rlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.codehaus.cargo.container.configuration.Configuration createConfiguration(String containerId, ContainerType containerType, Deployable[] deployables, CargoProject project) throws MojoExecutionException {
        org.codehaus.cargo.container.configuration.Configuration configuration;
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> configurationClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerConfiguration(containerId, containerType, this.getType(), configurationClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom configuration implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        if (this.getHome() == null) {
            if (project.isDaemonRun()) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), "");
            } else if (ConfigurationType.RUNTIME.equals((Object)this.getType())) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), null);
            } else {
                File home = new File(project.getBuildDirectory(), "cargo/configurations/" + containerId);
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), home.getAbsolutePath());
            }
        } else {
            configuration = factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        }
        if (this.getPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(this.getPropertiesFile());
                try {
                    properties.load(new BufferedInputStream(inputStream));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    configuration.setProperty(propertyName, propertyValue);
                }
            }
            catch (FileNotFoundException e) {
                configuration.getLogger().warn("Configuration property file [" + this.getPropertiesFile() + "] cannot be read", this.getClass().getName());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Configuration property file [" + this.getPropertiesFile() + "] cannot be loaded", (Exception)ioe);
            }
        }
        if (this.getProperties() != null) {
            for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
                String propertyValue = property.getValue();
                if (propertyValue == null) {
                    propertyValue = "";
                }
                configuration.setProperty(property.getKey(), propertyValue);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            FileConfig fileConfig;
            LocalConfiguration localConfiguration = (LocalConfiguration)configuration;
            if (deployables != null) {
                this.addStaticDeployables(containerId, localConfiguration, deployables, project);
            }
            if (this.getResources() != null) {
                this.addResources(containerId, localConfiguration, project);
            }
            if (this.getConfigfiles() != null) {
                for (int i = 0; i < this.getConfigfiles().length; ++i) {
                    fileConfig = this.getConfigfiles()[i];
                    localConfiguration.setConfigFileProperty(fileConfig);
                }
            }
            if (this.getFiles() != null) {
                for (int i = 0; i < this.getFiles().length; ++i) {
                    fileConfig = this.getFiles()[i];
                    localConfiguration.setFileProperty(fileConfig);
                }
            }
        }
        return configuration;
    }

    private void addResources(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (int i = 0; i < this.getResources().length; ++i) {
            configuration.addResource(this.getResources()[i].createResource(containerId, project));
        }
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration, Deployable[] deployables, CargoProject project) throws MojoExecutionException {
        for (Deployable deployable : deployables) {
            project.getLog().debug((CharSequence)("Scheduling deployable for deployment: [groupId [" + deployable.getGroupId() + "], artifactId [" + deployable.getArtifactId() + "], type [" + deployable.getType() + "], location [" + deployable.getLocation() + "], pingURL [" + deployable.getPingURL() + "]]"));
            configuration.addDeployable(deployable.createDeployable(containerId, project));
        }
    }
}

