/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.BaseSax2EventFromStaxProducer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class Sax2EventFromStaxStreamProducer
extends BaseSax2EventFromStaxProducer {
    private static final Log LOG = LogFactory.getLog(BaseSax2EventFromStaxProducer.class);
    private XMLStreamReader streamReader;

    public Sax2EventFromStaxStreamProducer(XMLStreamReader streamReader) {
        this.streamReader = streamReader;
    }

    @Override
    public void start() throws SAXException {
        int depth = 0;
        try {
            do {
                if ((depth = this.handleEventType(this.streamReader.getEventType(), depth)) == 0) continue;
                this.streamReader.next();
            } while (depth != 0);
        }
        catch (XMLStreamException e) {
            this.getErrorHandler().warning(new SAXParseException(e.getMessage(), this.getSAXLocator(e.getLocation()), null));
        }
    }

    @Override
    QName getQName() {
        return this.streamReader.getName();
    }

    @Override
    char[] getCharacters() {
        return this.streamReader.getText().toCharArray();
    }

    @Override
    void handleSpace() throws SAXException {
        LOG.info((Object)"< handleSpace >");
        String string = this.streamReader.getText();
        char[] chars = new char[string.length()];
        chars = string.toCharArray();
        this.getContentHandler().ignorableWhitespace(chars, 0, chars.length);
    }

    @Override
    void doStartPrefixMapping() throws SAXException {
        LOG.info((Object)"< doStartPrefixMapping >");
        Integer nsCounter = this.streamReader.getNamespaceCount();
        LinkedList<String> prefixList = new LinkedList<String>();
        for (int i = 0; i < nsCounter; ++i) {
            String prefix = this.getNonEmpty(this.streamReader.getNamespacePrefix(i));
            this.getContentHandler().startPrefixMapping(prefix, this.streamReader.getNamespaceURI(i));
            prefixList.add(prefix);
        }
        this.getPrefixes().push(prefixList);
    }

    @Override
    void doEndPrefixMapping() throws SAXException {
        List<String> prefixList = this.getPrefixes().pop();
        for (String prefix : prefixList) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    Attributes getAttributes() {
        Integer attCounter = this.streamReader.getAttributeCount();
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < attCounter; ++i) {
            QName qName = this.streamReader.getAttributeName(i);
            String uri = qName.getNamespaceURI();
            String localName = qName.getLocalPart();
            String prefix = qName.getPrefix();
            String qNameString = this.getQName(prefix, localName);
            String type = this.streamReader.getAttributeType(i);
            String value = this.streamReader.getAttributeValue(i);
            atts.addAttribute(uri, localName, qNameString, type, value);
        }
        return atts;
    }

    @Override
    Location getLocation() {
        return this.streamReader.getLocation();
    }
}

