/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.v2_0;

import groovy.lang.GroovyClassLoader;
import java.net.URL;
import java.security.CodeSource;
import java.util.Iterator;
import java.util.List;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.codehaus.gmaven.runtime.ClassCompiler;
import org.codehaus.gmaven.runtime.support.CompilerSupport;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.GroovyClass;

public class ClassCompilerFeature
extends FeatureSupport {
    public ClassCompilerFeature() {
        super(ClassCompiler.KEY);
    }

    protected Component doCreate() throws Exception {
        return new ClassCompilerImpl();
    }

    private class ClassCompilerImpl
    extends CompilerSupport
    implements ClassCompiler,
    ClassCompiler.Keys {
        private final CompilerConfiguration cc;
        private URL[] classPath;

        private ClassCompilerImpl() throws Exception {
            super((Feature)ClassCompilerFeature.this);
            this.cc = new CompilerConfiguration();
        }

        private void configure() {
            this.cc.setVerbose(this.config.get("verbose", false));
            this.cc.setDebug(this.config.get("debug", false));
            if (this.config.contains("tolerance")) {
                this.cc.setTolerance(this.config.get("tolerance", 0));
            }
            if (this.config.contains("targetBytecode")) {
                this.cc.setTargetBytecode(this.config.get("targetBytecode", (String)null));
            }
            if (this.config.contains("invokeDynamic") && Boolean.valueOf(this.config.get("invokeDynamic", false)).booleanValue()) {
                this.cc.getOptimizationOptions().put("indy", true);
                this.cc.getOptimizationOptions().put("int", false);
            }
            if (this.config.contains("scriptBaseClassname")) {
                this.cc.setScriptBaseClass(this.config.get("scriptBaseClassname", (String)null));
            }
            if (this.config.contains("defaultScriptExtension")) {
                this.cc.setDefaultScriptExtension(this.config.get("defaultScriptExtension", (String)null));
            }
            if (this.config.contains("warningLevel")) {
                this.cc.setTolerance(this.config.get("warningLevel", 0));
            }
            if (this.config.contains("sourceEncoding")) {
                this.cc.setSourceEncoding(this.config.get("sourceEncoding", (String)null));
            }
        }

        public int compile() throws Exception {
            if (this.sources.isEmpty()) {
                this.log.debug("No sources added to compile; skipping");
                return 0;
            }
            this.configure();
            this.cc.setTargetDirectory(this.getTargetDirectory().getCanonicalPath());
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            GroovyClassLoader gcl = new GroovyClassLoader(parent, this.cc);
            this.log.debug("Classpath:");
            URL[] classpath = this.getClassPath();
            for (int i = 0; i < classpath.length; ++i) {
                gcl.addURL(classpath[i]);
                this.log.debug("    {}", (Object)classpath[i]);
            }
            CodeSource security = null;
            GroovyClassLoader transformLoader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            for (int i = 0; i < classpath.length; ++i) {
                transformLoader.addURL(classpath[i]);
            }
            CompilationUnit cu = new CompilationUnit(this.cc, security, gcl, transformLoader);
            this.log.debug("Compiling {} sources", (Object)String.valueOf(this.sources.size()));
            for (URL url : this.sources) {
                this.log.debug("    {}", (Object)url);
                cu.addSource(url);
            }
            cu.compile();
            List classes = cu.getClasses();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compiled {} classes:", (Object)String.valueOf(classes.size()));
                Iterator iter = classes.iterator();
                while (iter.hasNext()) {
                    this.log.debug("    {}", (Object)((GroovyClass)iter.next()).getName());
                }
            }
            return classes.size();
        }
    }
}

