/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.sql.CallResultSet;
import groovy.sql.DataSet;
import groovy.sql.ExpandedVariable;
import groovy.sql.GroovyResultSet;
import groovy.sql.GroovyResultSetProxy;
import groovy.sql.GroovyRowResult;
import groovy.sql.InOutParameter;
import groovy.sql.InParameter;
import groovy.sql.OutParameter;
import groovy.sql.ResultSetOutParameter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class Sql {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private DataSource dataSource;
    private Connection useConnection;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = -1;
    private boolean warned;
    int updateCount = 0;
    private Closure configureStatement;
    public static final OutParameter ARRAY = new OutParameter(){

        public int getType() {
            return 2003;
        }
    };
    public static final OutParameter BIGINT = new OutParameter(){

        public int getType() {
            return -5;
        }
    };
    public static final OutParameter BINARY = new OutParameter(){

        public int getType() {
            return -2;
        }
    };
    public static final OutParameter BIT = new OutParameter(){

        public int getType() {
            return -7;
        }
    };
    public static final OutParameter BLOB = new OutParameter(){

        public int getType() {
            return 2004;
        }
    };
    public static final OutParameter BOOLEAN = new OutParameter(){

        public int getType() {
            return 16;
        }
    };
    public static final OutParameter CHAR = new OutParameter(){

        public int getType() {
            return 1;
        }
    };
    public static final OutParameter CLOB = new OutParameter(){

        public int getType() {
            return 2005;
        }
    };
    public static final OutParameter DATALINK = new OutParameter(){

        public int getType() {
            return 70;
        }
    };
    public static final OutParameter DATE = new OutParameter(){

        public int getType() {
            return 91;
        }
    };
    public static final OutParameter DECIMAL = new OutParameter(){

        public int getType() {
            return 3;
        }
    };
    public static final OutParameter DISTINCT = new OutParameter(){

        public int getType() {
            return 2001;
        }
    };
    public static final OutParameter DOUBLE = new OutParameter(){

        public int getType() {
            return 8;
        }
    };
    public static final OutParameter FLOAT = new OutParameter(){

        public int getType() {
            return 6;
        }
    };
    public static final OutParameter INTEGER = new OutParameter(){

        public int getType() {
            return 4;
        }
    };
    public static final OutParameter JAVA_OBJECT = new OutParameter(){

        public int getType() {
            return 2000;
        }
    };
    public static final OutParameter LONGVARBINARY = new OutParameter(){

        public int getType() {
            return -4;
        }
    };
    public static final OutParameter LONGVARCHAR = new OutParameter(){

        public int getType() {
            return -1;
        }
    };
    public static final OutParameter NULL = new OutParameter(){

        public int getType() {
            return 0;
        }
    };
    public static final OutParameter NUMERIC = new OutParameter(){

        public int getType() {
            return 2;
        }
    };
    public static final OutParameter OTHER = new OutParameter(){

        public int getType() {
            return 1111;
        }
    };
    public static final OutParameter REAL = new OutParameter(){

        public int getType() {
            return 7;
        }
    };
    public static final OutParameter REF = new OutParameter(){

        public int getType() {
            return 2006;
        }
    };
    public static final OutParameter SMALLINT = new OutParameter(){

        public int getType() {
            return 5;
        }
    };
    public static final OutParameter STRUCT = new OutParameter(){

        public int getType() {
            return 2002;
        }
    };
    public static final OutParameter TIME = new OutParameter(){

        public int getType() {
            return 92;
        }
    };
    public static final OutParameter TIMESTAMP = new OutParameter(){

        public int getType() {
            return 93;
        }
    };
    public static final OutParameter TINYINT = new OutParameter(){

        public int getType() {
            return -6;
        }
    };
    public static final OutParameter VARBINARY = new OutParameter(){

        public int getType() {
            return -3;
        }
    };
    public static final OutParameter VARCHAR = new OutParameter(){

        public int getType() {
            return 12;
        }
    };

    public static Sql newInstance(String url) throws SQLException {
        Connection connection = DriverManager.getConnection(url);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties) throws SQLException {
        Connection connection = DriverManager.getConnection(url, properties);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, properties);
    }

    public static Sql newInstance(String url, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, String user, String password, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, user, password);
    }

    public static Sql newInstance(String url, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url);
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public static void loadDriver(String driverClassName) throws ClassNotFoundException {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
            }
            catch (ClassNotFoundException e2) {
                try {
                    Sql.class.getClassLoader().loadClass(driverClassName);
                }
                catch (ClassNotFoundException e3) {
                    throw e;
                }
            }
        }
    }

    public static InParameter ARRAY(Object value) {
        return Sql.in(2003, value);
    }

    public static InParameter BIGINT(Object value) {
        return Sql.in(-5, value);
    }

    public static InParameter BINARY(Object value) {
        return Sql.in(-2, value);
    }

    public static InParameter BIT(Object value) {
        return Sql.in(-7, value);
    }

    public static InParameter BLOB(Object value) {
        return Sql.in(2004, value);
    }

    public static InParameter BOOLEAN(Object value) {
        return Sql.in(16, value);
    }

    public static InParameter CHAR(Object value) {
        return Sql.in(1, value);
    }

    public static InParameter CLOB(Object value) {
        return Sql.in(2005, value);
    }

    public static InParameter DATALINK(Object value) {
        return Sql.in(70, value);
    }

    public static InParameter DATE(Object value) {
        return Sql.in(91, value);
    }

    public static InParameter DECIMAL(Object value) {
        return Sql.in(3, value);
    }

    public static InParameter DISTINCT(Object value) {
        return Sql.in(2001, value);
    }

    public static InParameter DOUBLE(Object value) {
        return Sql.in(8, value);
    }

    public static InParameter FLOAT(Object value) {
        return Sql.in(6, value);
    }

    public static InParameter INTEGER(Object value) {
        return Sql.in(4, value);
    }

    public static InParameter JAVA_OBJECT(Object value) {
        return Sql.in(2000, value);
    }

    public static InParameter LONGVARBINARY(Object value) {
        return Sql.in(-4, value);
    }

    public static InParameter LONGVARCHAR(Object value) {
        return Sql.in(-1, value);
    }

    public static InParameter NULL(Object value) {
        return Sql.in(0, value);
    }

    public static InParameter NUMERIC(Object value) {
        return Sql.in(2, value);
    }

    public static InParameter OTHER(Object value) {
        return Sql.in(1111, value);
    }

    public static InParameter REAL(Object value) {
        return Sql.in(7, value);
    }

    public static InParameter REF(Object value) {
        return Sql.in(2006, value);
    }

    public static InParameter SMALLINT(Object value) {
        return Sql.in(5, value);
    }

    public static InParameter STRUCT(Object value) {
        return Sql.in(2002, value);
    }

    public static InParameter TIME(Object value) {
        return Sql.in(92, value);
    }

    public static InParameter TIMESTAMP(Object value) {
        return Sql.in(93, value);
    }

    public static InParameter TINYINT(Object value) {
        return Sql.in(-6, value);
    }

    public static InParameter VARBINARY(Object value) {
        return Sql.in(-3, value);
    }

    public static InParameter VARCHAR(Object value) {
        return Sql.in(12, value);
    }

    public static InParameter in(final int type, final Object value) {
        return new InParameter(){

            public int getType() {
                return type;
            }

            public Object getValue() {
                return value;
            }
        };
    }

    public static OutParameter out(final int type) {
        return new OutParameter(){

            public int getType() {
                return type;
            }
        };
    }

    public static InOutParameter inout(final InParameter in) {
        return new InOutParameter(){

            public int getType() {
                return in.getType();
            }

            public Object getValue() {
                return in.getValue();
            }
        };
    }

    public static ResultSetOutParameter resultSet(final int type) {
        return new ResultSetOutParameter(){

            public int getType() {
                return type;
            }
        };
    }

    public static ExpandedVariable expand(final Object object) {
        return new ExpandedVariable(){

            public Object getObject() {
                return object;
            }
        };
    }

    public Sql(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Sql(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("Must specify a non-null Connection");
        }
        this.useConnection = connection;
    }

    public Sql(Sql parent) {
        this.dataSource = parent.dataSource;
        this.useConnection = parent.useConnection;
    }

    public DataSet dataSet(String table) {
        return new DataSet(this, table);
    }

    public DataSet dataSet(Class type) {
        return new DataSet(this, type);
    }

    public void query(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = this.createConnection(connection);
        this.configure(statement);
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    private Statement createConnection(Connection connection) throws SQLException {
        if (this.resultSetHoldability == -1) {
            return connection.createStatement(this.resultSetType, this.resultSetConcurrency);
        }
        return connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    public void query(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            results = statement.executeQuery();
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(GString gstring, Closure closure) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.query(sql, params, closure);
    }

    public void eachRow(String sql, Closure closure) throws SQLException {
        this.eachRow(sql, (Closure)null, closure);
    }

    public void eachRow(String sql, Closure metaClosure, Closure rowClosure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = this.createConnection(connection);
        this.configure(statement);
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            if (metaClosure != null) {
                metaClosure.call(results.getMetaData());
            }
            GroovyResultSet groovyRS = new GroovyResultSetProxy(results).getImpl();
            while (groovyRS.next()) {
                rowClosure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void eachRow(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            results = statement.executeQuery();
            GroovyResultSet groovyRS = new GroovyResultSetProxy(results).getImpl();
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void eachRow(GString gstring, Closure closure) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.eachRow(sql, params, closure);
    }

    public void queryEach(String sql, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, closure);
    }

    public void queryEach(String sql, List params, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, params, closure);
    }

    public void queryEach(GString gstring, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(gstring, closure);
    }

    public List rows(String sql) throws SQLException {
        return this.rows(sql, (Closure)null);
    }

    public List rows(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.rows(sql, params);
    }

    public List rows(String sql, Closure metaClosure) throws SQLException {
        ArrayList<GroovyRowResult> results = new ArrayList<GroovyRowResult>();
        Connection connection = this.createConnection();
        Statement statement = this.createConnection(connection);
        this.configure(statement);
        ResultSet rs = null;
        try {
            this.log.fine(sql);
            rs = statement.executeQuery(sql);
            if (metaClosure != null) {
                metaClosure.call(rs.getMetaData());
            }
            while (rs.next()) {
                results.add(DefaultGroovyMethods.toRowResult(rs));
            }
            ArrayList<GroovyRowResult> arrayList = results;
            this.closeResources(connection, statement, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, rs);
                throw throwable;
            }
        }
    }

    public List rows(String sql, List params) throws SQLException {
        ArrayList<GroovyRowResult> results = new ArrayList<GroovyRowResult>();
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            rs = statement.executeQuery();
            while (rs.next()) {
                results.add(DefaultGroovyMethods.toRowResult(rs));
            }
            ArrayList<GroovyRowResult> arrayList = results;
            this.closeResources(connection, statement, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, rs);
                throw throwable;
            }
        }
    }

    public Object firstRow(String sql) throws SQLException {
        List rows = this.rows(sql);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    public Object firstRow(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.firstRow(sql, params);
    }

    public Object firstRow(String sql, List params) throws SQLException {
        List rows = this.rows(sql, params);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    public boolean execute(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = this.createConnection(connection);
            this.configure(statement);
            boolean isResultSet = statement.execute(sql);
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            boolean isResultSet = statement.execute();
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.execute(sql, params);
    }

    public List executeInsert(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = this.createConnection(connection);
            this.configure(statement);
            boolean hasResultSet = statement.execute(sql, 1);
            ArrayList autoKeys = new ArrayList();
            ResultSet keys = statement.getGeneratedKeys();
            int count = keys.getMetaData().getColumnCount();
            while (keys.next()) {
                ArrayList<Object> rowKeys = new ArrayList<Object>(count);
                for (int i = 1; i <= count; ++i) {
                    rowKeys.add(keys.getObject(i));
                }
                autoKeys.add(rowKeys);
            }
            this.updateCount = statement.getUpdateCount();
            ArrayList arrayList = autoKeys;
            this.closeResources(connection, statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public List executeInsert(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql, 1);
            this.setParameters(params, statement);
            this.configure(statement);
            this.updateCount = statement.executeUpdate();
            ArrayList autoKeys = new ArrayList();
            ResultSet keys = statement.getGeneratedKeys();
            int count = keys.getMetaData().getColumnCount();
            while (keys.next()) {
                ArrayList<Object> rowKeys = new ArrayList<Object>(count);
                for (int i = 1; i <= count; ++i) {
                    rowKeys.add(keys.getObject(i));
                }
                autoKeys.add(rowKeys);
            }
            ArrayList arrayList = autoKeys;
            this.closeResources(connection, statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public List executeInsert(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.executeInsert(sql, params);
    }

    public int executeUpdate(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = this.createConnection(connection);
            this.configure(statement);
            int n = this.updateCount = statement.executeUpdate(sql);
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            int n = this.updateCount = statement.executeUpdate();
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(GString gstring) throws SQLException {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.executeUpdate(sql, params);
    }

    public int call(String sql) throws Exception {
        return this.call(sql, Collections.EMPTY_LIST);
    }

    public int call(String sql, List params) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        try {
            this.log.fine(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            this.log.log(Level.FINE, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public void call(String sql, List params, Closure closure) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        try {
            this.log.fine(sql);
            this.setParameters(params, statement);
            statement.execute();
            ArrayList<Object> results = new ArrayList<Object>();
            int indx = 0;
            int inouts = 0;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (value instanceof OutParameter) {
                    if (value instanceof ResultSetOutParameter) {
                        results.add(CallResultSet.getImpl(statement, indx));
                    } else {
                        Object o = statement.getObject(indx + 1);
                        if (o instanceof ResultSet) {
                            results.add(new GroovyResultSetProxy((ResultSet)o).getImpl());
                        } else {
                            results.add(o);
                        }
                    }
                    ++inouts;
                }
                ++indx;
            }
            closure.call(results.toArray(new Object[inouts]));
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public int call(GString gstring) throws Exception {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.call(sql, params);
    }

    public void call(GString gstring, Closure closure) throws Exception {
        List params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.call(sql, params, closure);
    }

    public void close() throws SQLException {
        if (this.useConnection != null) {
            this.useConnection.close();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void commit() {
        try {
            this.useConnection.commit();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Caught exception commiting connection: " + e, e);
        }
    }

    public void rollback() {
        try {
            this.useConnection.rollback();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Caught exception rollbacking connection: " + e, e);
        }
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public Connection getConnection() {
        return this.useConnection;
    }

    public void withStatement(Closure configureStatement) {
        this.configureStatement = configureStatement;
    }

    protected String asSql(GString gstring, List values) {
        String[] strings = gstring.getStrings();
        if (strings.length <= 0) {
            throw new IllegalArgumentException("No SQL specified in GString: " + gstring);
        }
        boolean nulls = false;
        StringBuffer buffer = new StringBuffer();
        boolean warned = false;
        Iterator iter = values.iterator();
        for (int i = 0; i < strings.length; ++i) {
            String text = strings[i];
            if (text != null) {
                buffer.append(text);
            }
            if (!iter.hasNext()) continue;
            Object value = iter.next();
            if (value != null) {
                if (value instanceof ExpandedVariable) {
                    buffer.append(((ExpandedVariable)value).getObject());
                    iter.remove();
                    continue;
                }
                boolean validBinding = true;
                if (i < strings.length - 1) {
                    String nextText = strings[i + 1];
                    if ((text.endsWith("\"") || text.endsWith("'")) && (nextText.startsWith("'") || nextText.startsWith("\""))) {
                        if (!warned) {
                            this.log.warning("In Groovy SQL please do not use quotes around dynamic expressions (which start with $) as this means we cannot use a JDBC PreparedStatement and so is a security hole. Groovy has worked around your mistake but the security hole is still there. The expression so far is: " + buffer.toString() + "?" + nextText);
                            warned = true;
                        }
                        buffer.append(value);
                        iter.remove();
                        validBinding = false;
                    }
                }
                if (!validBinding) continue;
                buffer.append("?");
                continue;
            }
            nulls = true;
            iter.remove();
            buffer.append("?'\"?");
        }
        String sql = buffer.toString();
        if (nulls) {
            sql = this.nullify(sql);
        }
        return sql;
    }

    protected String nullify(String sql) {
        int firstWhere = this.findWhereKeyword(sql);
        if (firstWhere >= 0) {
            Pattern[] patterns = new Pattern[]{Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)!=\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)<>\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?[^<>])=\\s{0,1}(\\s*)\\?'\"\\?(.*)")};
            String[] replacements = new String[]{"$1 is not $2null$3", "$1 is not $2null$3", "$1 is $2null$3"};
            for (int i = 0; i < patterns.length; ++i) {
                Matcher matcher = patterns[i].matcher(sql);
                while (matcher.matches()) {
                    sql = matcher.replaceAll(replacements[i]);
                    matcher = patterns[i].matcher(sql);
                }
            }
        }
        return sql.replaceAll("\\?'\"\\?", "null");
    }

    protected int findWhereKeyword(String sql) {
        char[] chars = sql.toLowerCase().toCharArray();
        char[] whereChars = "where".toCharArray();
        boolean inString = false;
        boolean noWhere = true;
        int inWhere = 0;
        block3: for (int i = 0; i < chars.length && noWhere; ++i) {
            switch (chars[i]) {
                case '\'': {
                    inString = !inString;
                    continue block3;
                }
                default: {
                    if (inString || chars[i] != whereChars[inWhere] || ++inWhere != whereChars.length) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    protected List getParameters(GString gstring) {
        return new ArrayList<Object>(Arrays.asList(gstring.getValues()));
    }

    protected void setParameters(List params, PreparedStatement statement) throws SQLException {
        int i = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            this.setObject(statement, i++, value);
        }
    }

    protected void setObject(PreparedStatement statement, int i, Object value) throws SQLException {
        if (value instanceof InParameter || value instanceof OutParameter) {
            if (value instanceof InParameter) {
                InParameter in = (InParameter)value;
                Object val = in.getValue();
                if (null == val) {
                    statement.setNull(i, in.getType());
                } else {
                    statement.setObject(i, val, in.getType());
                }
            }
            if (value instanceof OutParameter) {
                try {
                    OutParameter out = (OutParameter)value;
                    ((CallableStatement)statement).registerOutParameter(i, out.getType());
                }
                catch (ClassCastException e) {
                    throw new SQLException("Cannot register out parameter.");
                }
            }
        } else {
            statement.setObject(i, value);
        }
    }

    protected Connection createConnection() throws SQLException {
        if (this.dataSource != null) {
            Connection con = null;
            try {
                con = (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        return Sql.this.dataSource.getConnection();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw (RuntimeException)e;
            }
            return con;
        }
        return this.useConnection;
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing resultSet: " + e, e);
            }
        }
        this.closeResources(connection, statement);
    }

    protected void closeResources(Connection connection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing statement: " + e, e);
            }
        }
        if (this.dataSource != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing connection: " + e, e);
            }
        }
    }

    private void warnDeprecated() {
        if (!this.warned) {
            this.warned = true;
            this.log.warning("queryEach() is deprecated, please use eachRow() instead");
        }
    }

    protected void configure(Statement statement) {
        if (this.configureStatement != null) {
            this.configureStatement.call(statement);
        }
    }
}

