/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    public static final GenericsType[] EMPTY_GENERICS_ARRAY = new GenericsType[0];

    public static GenericsType[] alignGenericTypes(GenericsType[] redirectGenericTypes, GenericsType[] parameterizedTypes, GenericsType[] alignmentTarget) {
        if (alignmentTarget == null) {
            return EMPTY_GENERICS_ARRAY;
        }
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            return alignmentTarget;
        }
        GenericsType[] generics = new GenericsType[alignmentTarget.length];
        for (GenericsType currentTarget : alignmentTarget) {
            GenericsType match = null;
            if (redirectGenericTypes != null) {
                for (int j = 0; j < redirectGenericTypes.length && match == null; ++j) {
                    ClassNode[] upper;
                    GenericsType redirectGenericType = redirectGenericTypes[j];
                    if (!redirectGenericType.isCompatibleWith(currentTarget.getType())) continue;
                    match = parameterizedTypes[j];
                    if (!currentTarget.isWildcard()) continue;
                    ClassNode lower = currentTarget.getLowerBound() != null ? match.getType() : null;
                    ClassNode[] currentUpper = currentTarget.getUpperBounds();
                    ClassNode[] classNodeArray = upper = currentUpper != null ? new ClassNode[currentUpper.length] : null;
                    if (upper != null) {
                        for (int k = 0; k < upper.length; ++k) {
                            upper[k] = currentUpper[k].isGenericsPlaceHolder() ? match.getType() : currentUpper[k];
                        }
                    }
                    match = new GenericsType(ClassHelper.makeWithoutCaching("?"), upper, lower);
                    match.setWildcard(true);
                }
            }
            if (match == null) {
                match = currentTarget;
            }
            generics[i] = match;
        }
        return generics;
    }

    public static GenericsType buildWildcardType(ClassNode ... types) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        GenericsType gt = new GenericsType(base, types, null);
        gt.setWildcard(true);
        return gt;
    }

    public static Map<String, GenericsType> extractPlaceholders(ClassNode cn) {
        HashMap<String, GenericsType> ret = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(cn, ret);
        return ret;
    }

    public static void extractPlaceholders(ClassNode node, Map<String, GenericsType> map) {
        if (node == null) {
            return;
        }
        if (!node.isUsingGenerics() || !node.isRedirectNode()) {
            return;
        }
        GenericsType[] parameterized = node.getGenericsTypes();
        if (parameterized == null) {
            return;
        }
        GenericsType[] redirectGenericsTypes = node.redirect().getGenericsTypes();
        if (redirectGenericsTypes == null) {
            redirectGenericsTypes = parameterized;
        }
        for (int i = 0; i < redirectGenericsTypes.length; ++i) {
            String name;
            GenericsType redirectType = redirectGenericsTypes[i];
            if (!redirectType.isPlaceholder() || map.containsKey(name = redirectType.getName())) continue;
            map.put(name, parameterized[i]);
        }
    }

    public static ClassNode parameterizeInterfaceGenerics(ClassNode classNode, ClassNode anInterface) {
        ClassNode[] interfaces;
        ClassNode interfaceFromClassNode = null;
        for (ClassNode node : interfaces = classNode.getInterfaces()) {
            if (node.equals(anInterface)) {
                interfaceFromClassNode = node;
                break;
            }
            if (!node.implementsInterface(anInterface)) continue;
            return GenericsUtils.parameterizeInterfaceGenerics(GenericsUtils.parameterizeInterfaceGenerics(classNode, node), anInterface);
        }
        if (interfaceFromClassNode == null && classNode.getUnresolvedSuperClass() != null) {
            return GenericsUtils.parameterizeInterfaceGenerics(classNode.getUnresolvedSuperClass(), anInterface);
        }
        if (interfaceFromClassNode == null) {
            return anInterface;
        }
        HashMap<String, GenericsType> parameters = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(classNode, parameters);
        ClassNode node = interfaceFromClassNode.getPlainNodeReference();
        GenericsType[] interfaceGTs = interfaceFromClassNode.getGenericsTypes();
        GenericsType[] types = new GenericsType[interfaceGTs.length];
        for (int i = 0; i < interfaceGTs.length; ++i) {
            String name;
            GenericsType interfaceGT;
            types[i] = interfaceGT = interfaceGTs[i];
            if (!interfaceGT.isPlaceholder() || !parameters.containsKey(name = interfaceGT.getName())) continue;
            types[i] = (GenericsType)parameters.get(name);
        }
        node.setGenericsTypes(types);
        return node;
    }
}

