/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.feature.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.codehaus.groovy.maven.feature.Configuration;
import org.codehaus.groovy.maven.feature.Feature;
import org.codehaus.groovy.maven.feature.Provider;
import org.codehaus.groovy.maven.feature.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingProvider
implements Provider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Provider delegate;
    private static final Class[] PROXY_INTERFACES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DelegatingProvider(Provider delegate) {
        this.delegate = delegate;
    }

    public DelegatingProvider(ClassLoader classLoader, InvocationHandler handler) {
        this(DelegatingProvider.createProxy(classLoader, handler));
    }

    public DelegatingProvider(InvocationHandler handler) {
        this(DelegatingProvider.createProxy(handler));
    }

    protected DelegatingProvider() {
        this((Provider)null);
    }

    public synchronized Provider getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = this.findDelegate();
                this.log.trace("Found delegate: {}", (Object)this.delegate);
            }
            catch (Exception e) {
                this.log.debug("Failed to find delegate: " + e, (Throwable)e);
            }
        }
        return this.delegate;
    }

    protected Provider findDelegate() throws Exception {
        throw new InternalError("No delegate bound; Provide a delegate instance or override 'findDelegate()'");
    }

    public String key() {
        return this.getDelegate().key();
    }

    public String name() {
        return this.getDelegate().name();
    }

    public Version version() {
        return this.getDelegate().version();
    }

    public boolean supported() {
        return this.getDelegate().supported();
    }

    public void require() {
        this.getDelegate().require();
    }

    public Configuration config() {
        return this.getDelegate().config();
    }

    public Collection features() {
        return this.getDelegate().features();
    }

    public Feature feature(String key) {
        return this.getDelegate().feature(key);
    }

    public Feature feature(Class key) {
        return this.getDelegate().feature(key);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getDelegate().equals(obj);
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public static Provider createProxy(ClassLoader classLoader, InvocationHandler handler) {
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && handler == null) {
            throw new AssertionError();
        }
        return (Provider)Proxy.newProxyInstance(classLoader, PROXY_INTERFACES, handler);
    }

    public static Provider createProxy(InvocationHandler handler) {
        return DelegatingProvider.createProxy(Thread.currentThread().getContextClassLoader(), handler);
    }

    static {
        $assertionsDisabled = !DelegatingProvider.class.desiredAssertionStatus();
        PROXY_INTERFACES = new Class[]{Provider.class};
    }
}

