/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.loader.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.groovy.maven.feature.Provider;
import org.codehaus.groovy.maven.feature.ProviderLoader;
import org.codehaus.groovy.maven.runtime.loader.LoaderSupport;
import org.codehaus.groovy.maven.runtime.loader.artifact.ArtifactHandler;
import org.codehaus.plexus.PlexusContainer;

public class ArtifactProviderLoader
extends LoaderSupport
implements ProviderLoader {
    private ArtifactHandler handler;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArtifactHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ArtifactHandler handler) {
        this.handler = handler;
    }

    public Map load(String key) throws Exception {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (this.handler == null) {
            this.log.error("Artifact handler has not been configured; unable to load anything");
            return null;
        }
        this.log.debug("Loading providers: {}", (Object)key);
        Artifact query = this.handler.createQuery(key);
        return this.load(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map load(Artifact query) throws Exception {
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        PlexusContainer container = this.findContainer(query);
        ClassRealm childRealm = container.getContainerRealm();
        ClassLoader classLoader = childRealm.getClassLoader();
        Map discovered = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            discovered = container.lookupMap(Provider.class.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        if (discovered == null || discovered.isEmpty()) {
            container.dispose();
        }
        return discovered;
    }

    private PlexusContainer findContainer(Artifact query) throws Exception {
        PlexusContainer container;
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        String id = query.getDependencyConflictId();
        PlexusContainer parent = this.getContainer();
        if (parent.hasChildContainer(id)) {
            container = parent.getChildContainer(id);
            this.log.trace("Re-using container: {}", (Object)container);
        } else {
            List classPath = this.buildClassPath(query);
            HashMap context = new HashMap();
            container = parent.createChildContainer(id, classPath, context);
            this.log.trace("Created new container: {}", (Object)container);
        }
        return container;
    }

    private List buildClassPath(Artifact query) throws Exception {
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        Artifact artifact = this.handler.createDependency(query);
        ArtifactResolutionResult result = this.handler.resolve(artifact, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
        this.log.debug("Classpath: {}", (Object)artifact);
        ArrayList<File> classPath = new ArrayList<File>();
        Iterator iter = result.getArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact element = (Artifact)iter.next();
            File file = element.getFile();
            this.log.debug("    {}", (Object)file);
            classPath.add(file);
        }
        return classPath;
    }

    static {
        $assertionsDisabled = !ArtifactProviderLoader.class.desiredAssertionStatus();
    }
}

