/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.support;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.codehaus.groovy.maven.feature.Configuration;
import org.codehaus.groovy.maven.feature.Feature;
import org.codehaus.groovy.maven.feature.support.ComponentSupport;
import org.codehaus.groovy.maven.runtime.TraceSanitizer;

public class TraceSanitizerSupport
extends ComponentSupport
implements TraceSanitizer {
    public static final String[] FILTERED_PREFIXES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TraceSanitizerSupport(Feature feature, Configuration config) {
        super(feature, config);
    }

    public TraceSanitizerSupport(Feature feature) {
        super(feature);
    }

    public boolean filter(String className) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < FILTERED_PREFIXES.length; ++i) {
            if (!className.startsWith(FILTERED_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }

    public boolean filter(Class type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        return this.filter(type.getName());
    }

    public Throwable sanitize(Throwable t, boolean deep) {
        if (!$assertionsDisabled && t == null) {
            throw new AssertionError();
        }
        if (deep) {
            Throwable current = t;
            while (current.getCause() != null) {
                current = this.sanitize(current.getCause(), false);
            }
        }
        StackTraceElement[] trace = t.getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (int i = 0; i < trace.length; ++i) {
            if (this.filter(trace[i].getClassName())) continue;
            list.add(trace[i]);
        }
        t.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return t;
    }

    public Throwable sanitize(Throwable t) {
        return this.sanitize(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Throwable t, PrintWriter out, boolean deep) {
        if (!$assertionsDisabled && t == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        StackTraceElement[] trace = this.sanitize(t, deep).getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.print("at ");
                out.print(trace[i].getClassName());
                out.print("(");
                out.print(trace[i].getMethodName());
                out.print(":");
                out.print(trace[i].getLineNumber());
                out.println(")");
                continue;
            }
        }
    }

    public void print(Throwable t, PrintWriter out) {
        this.print(t, out, false);
    }

    public void print(Throwable t) {
        this.print(t, new PrintWriter(System.err, true));
    }

    static {
        $assertionsDisabled = !TraceSanitizerSupport.class.desiredAssertionStatus();
        FILTERED_PREFIXES = new String[]{"groovy.", "org.codehaus.groovy.", "java.", "javax.", "sun.", "gjdk.groovy."};
    }
}

