/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.support.stubgen.parser;

import java.net.URL;

public final class SourceType {
    public static final SourceType GROOVY = new SourceType("GROOVY", 0);
    public static final String GROOVY_EXT = ".groovy";
    public static final String GROOVY_NAME = "GROOVY";
    public static final int GROOVY_CODE = 0;
    public static final SourceType JAVA = new SourceType("JAVA", 1);
    public static final String JAVA_EXT = ".java";
    public static final String JAVA_NAME = "JAVA";
    public static final int JAVA_CODE = 1;
    public static final String SOURCE_TYPE_TAG = "source-type";
    public final String name;
    public final int code;

    private SourceType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String toString() {
        return this.name;
    }

    public static SourceType forURL(URL url) {
        String name = url.getFile().toLowerCase();
        if (name.endsWith(GROOVY_EXT)) {
            return GROOVY;
        }
        if (name.endsWith(JAVA_EXT)) {
            return JAVA;
        }
        throw new IllegalArgumentException("Unable to determine source type from URL: " + url);
    }

    public static SourceType forName(String name) {
        if (name.equals(GROOVY_NAME)) {
            return GROOVY;
        }
        if (name.equals(JAVA_NAME)) {
            return JAVA;
        }
        throw new IllegalArgumentException("Unable to determine source type from name: " + name);
    }

    public static SourceType forCode(int code) {
        if (code == 0) {
            return GROOVY;
        }
        if (code == 1) {
            return JAVA;
        }
        throw new IllegalArgumentException("Unable to determine source type from code: " + code);
    }
}

