/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip.model.render;

import org.codehaus.groovy.maven.gossip.Event;
import org.codehaus.groovy.maven.gossip.model.render.Renderer;

public class SimpleRenderer
extends Renderer {
    private boolean includeName = false;
    private boolean shortName = false;
    private int nameWidth = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String toString() {
        return "SimpleRenderer{includeName=" + this.includeName + ", shortName=" + this.shortName + ", nameWidth=" + this.nameWidth + '}';
    }

    public boolean getIncludeName() {
        return this.includeName;
    }

    public void setIncludeName(boolean flag) {
        this.includeName = flag;
    }

    public void setIncludeName(String flag) {
        this.setIncludeName(Boolean.valueOf(flag));
    }

    public void setShortName(boolean flag) {
        this.shortName = flag;
    }

    public void setShortName(String flag) {
        this.setShortName(Boolean.valueOf(flag));
    }

    public void setNameWidth(int width) {
        this.nameWidth = width;
    }

    public void setNameWidth(String width) {
        this.setNameWidth(Integer.parseInt(width));
    }

    public String render(Event event) {
        int i;
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        this.log.trace("Rendering: {}", event);
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        buff.append(event.level.label);
        buff.append("]");
        switch (event.level.id) {
            case 20: 
            case 30: {
                buff.append(" ");
            }
        }
        buff.append(" ");
        if (this.includeName) {
            String name = event.logger.getName();
            if (this.shortName && (i = name.lastIndexOf(".")) != -1) {
                name = name.substring(i + 1, name.length());
            }
            if (this.nameWidth > 0) {
                name = SimpleRenderer.rightPad(name, this.nameWidth, " ");
            }
            buff.append(name);
            buff.append("- ");
        }
        buff.append(event.message);
        buff.append(NEWLINE);
        if (event.cause != null) {
            buff.append(event.cause);
            buff.append(NEWLINE);
            StackTraceElement[] trace = event.cause.getStackTrace();
            for (i = 0; i < trace.length; ++i) {
                buff.append("    ");
                buff.append(trace[i]);
                buff.append(NEWLINE);
            }
        }
        return buff.toString();
    }

    public static String repeat(String str, int repeat) {
        StringBuffer buff = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buff.append(str);
        }
        return buff.toString();
    }

    public static String rightPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = str + SimpleRenderer.repeat(delim, size);
        }
        return str;
    }

    static {
        $assertionsDisabled = !SimpleRenderer.class.desiredAssertionStatus();
    }
}

