/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.enforcer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.enforcer.MavenLogger;
import org.codehaus.mojo.animal_sniffer.enforcer.Signature;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class CheckSignatureRule
implements EnforcerRule {
    protected Signature signature;
    protected String[] ignores;
    protected boolean ignoreDependencies = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            List classpathElements = (List)helper.evaluate("${project.compileClasspathElements}");
            File outputDirectory = new File((String)helper.evaluate("${project.build.outputDirectory}"));
            ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            ArtifactFactory artifactFactory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            helper.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(artifactFactory);
            resolver.resolve(a, project.getRemoteArtifactRepositories(), localRepository);
            MavenLogger logger = new MavenLogger(helper.getLog());
            Set ignoredPackages = this.buildPackageList(outputDirectory, classpathElements, logger);
            if (this.ignores != null) {
                for (int i = 0; i < this.ignores.length; ++i) {
                    String ignore = this.ignores[i];
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)logger);
            signatureChecker.setCheckJars(false);
            signatureChecker.process(outputDirectory);
            if (signatureChecker.isSignatureBroken()) {
                throw new EnforcerRuleException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new EnforcerRuleException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private Set buildPackageList(File outputDirectory, List classpathElements, Logger logger) throws IOException {
        ClassListBuilder plb = new ClassListBuilder(logger);
        this.apply((ClassFileVisitor)plb, outputDirectory, classpathElements);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v, File outputDirectory, List classpathElements) throws IOException {
        v.process(outputDirectory);
        if (this.ignoreDependencies) {
            Iterator itr = classpathElements.iterator();
            while (itr.hasNext()) {
                String path = (String)itr.next();
                v.process(new File(path));
            }
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return this.getClass().getName() + new Random().nextLong();
    }
}

