/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.OS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.cassandra.CassandraMonitor;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCassandraMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/cassandra")
    protected File cassandraDir;
    @Parameter(readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    private File testClassesDirectory;
    @Parameter(defaultValue="false")
    protected boolean addTestClasspath;
    @Parameter(defaultValue="false")
    protected boolean addMainClasspath;
    @Parameter(property="cassandra.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true, required=true)
    private List<Artifact> pluginDependencies;
    @Parameter(defaultValue="${plugin.pluginArtifact}", readonly=true, required=true)
    private Artifact pluginArtifact;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter
    private String yaml;
    @Parameter(defaultValue="127.0.0.1", required=true)
    protected String rpcAddress;
    @Parameter(property="cassandra.jmxPort", defaultValue="7199")
    protected int jmxPort;
    @Parameter(property="cassandra.nativeTransportPort", defaultValue="9042")
    protected int nativeTransportPort;
    @Parameter(property="cassandra.startNativeTransport", defaultValue="true")
    protected boolean startNativeTransport;
    @Parameter(defaultValue="127.0.0.1")
    protected String listenAddress;
    @Parameter(property="cassandra.storagePort", defaultValue="7000")
    protected int storagePort;
    @Parameter(property="cassandra.stopPort", defaultValue="8081")
    protected int stopPort;
    @Parameter(property="cassandra.stopKey", defaultValue="cassandra-maven-plugin")
    protected String stopKey;
    @Parameter(property="cassandra.maxMemory", defaultValue="512")
    protected int maxMemory;
    @Parameter(property="cassandra.keyspace")
    protected String keyspace;
    @Parameter
    protected Map<String, String> systemPropertyVariables;
    @Parameter(defaultValue="ERROR")
    protected String logLevel;

    protected void createCassandraJar(File jarFile, String mainClass) throws IOException {
        this.createCassandraJar(jarFile, mainClass, this.cassandraDir);
    }

    protected boolean useJdk11Options() {
        return false;
    }

    protected void createCassandraJar(File jarFile, String mainClass, File cassandraDir) throws IOException {
        File conf = new File(cassandraDir, "conf");
        try (FileOutputStream fos = new FileOutputStream(jarFile);
             JarOutputStream jos = new JarOutputStream(fos);){
            jos.setLevel(0);
            jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            Manifest man = new Manifest();
            StringBuilder cp = new StringBuilder();
            cp.append(new URL(conf.toURI().toASCIIString()).toExternalForm());
            cp.append(' ');
            this.getLog().debug((CharSequence)("Adding plugin artifact: " + ArtifactUtils.versionlessKey((Artifact)this.pluginArtifact) + " to the classpath"));
            cp.append(new URL(this.pluginArtifact.getFile().toURI().toASCIIString()).toExternalForm());
            cp.append(' ');
            for (Artifact artifact : this.pluginDependencies) {
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + ArtifactUtils.versionlessKey((Artifact)artifact) + " to the classpath"));
                cp.append(new URL(artifact.getFile().toURI().toASCIIString()).toExternalForm());
                cp.append(' ');
            }
            if (this.addMainClasspath || this.addTestClasspath) {
                if (this.addTestClasspath) {
                    this.getLog().debug((CharSequence)("Adding: " + this.testClassesDirectory + " to the classpath"));
                    cp.append(new URL(this.testClassesDirectory.toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
                if (this.addMainClasspath) {
                    this.getLog().debug((CharSequence)("Adding: " + this.classesDirectory + " to the classpath"));
                    cp.append(new URL(this.classesDirectory.toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
                for (Artifact artifact : this.project.getArtifacts()) {
                    if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) && !this.addTestClasspath) continue;
                    this.getLog().debug((CharSequence)("Adding dependency: " + ArtifactUtils.versionlessKey((Artifact)artifact) + " to the classpath"));
                    cp.append(new URL(artifact.getFile().toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
            }
            man.getMainAttributes().putValue("Manifest-Version", "1.0");
            man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            man.getMainAttributes().putValue("Main-Class", mainClass);
            man.write(jos);
        }
    }

    protected void createCassandraHome() throws IOException {
        this.createCassandraHome(this.cassandraDir, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress});
    }

    protected void createCassandraHome(File cassandraDir, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds) throws IOException {
        File cassandraJar;
        File log4jClientConfig;
        File log4jServerConfig;
        File bin = new File(cassandraDir, "bin");
        File conf = new File(cassandraDir, "conf");
        File data = new File(cassandraDir, "data");
        File commitlog = new File(cassandraDir, "commitlog");
        File cdcRawDirectory = new File(cassandraDir, "cdcRawDirectory");
        if (!Files.exists(cdcRawDirectory.toPath(), new LinkOption[0])) {
            Files.createDirectories(cdcRawDirectory.toPath(), new FileAttribute[0]);
        }
        File savedCaches = new File(cassandraDir, "saved_caches");
        for (File dir : Arrays.asList(cassandraDir, bin, conf, data, commitlog, savedCaches)) {
            if (dir.isFile()) {
                this.getLog().debug((CharSequence)("Deleting file " + dir + " as we need to create a directory with the same name."));
                if (!dir.delete()) {
                    this.getLog().warn((CharSequence)("Could not delete file " + dir));
                }
            }
            if (dir.isDirectory()) continue;
            this.getLog().debug((CharSequence)("Creating directory " + dir + " as it does not exist."));
            if (dir.mkdirs()) continue;
            this.getLog().warn((CharSequence)("Could not create directory " + dir));
        }
        File cassandraYaml = new File(conf, "cassandra.yaml");
        if (Utils.shouldGenerateResource(this.project, cassandraYaml)) {
            this.getLog().debug((CharSequence)((cassandraYaml.isFile() ? "Updating " : "Creating ") + cassandraYaml));
            this.createCassandraYaml(cassandraYaml, data, commitlog, savedCaches, listenAddress, rpcAddress, initialToken, seeds, cdcRawDirectory);
        }
        if (Utils.shouldGenerateResource(this.project, log4jServerConfig = new File(conf, "log4j-server.xml"))) {
            this.getLog().debug((CharSequence)((log4jServerConfig.isFile() ? "Updating " : "Creating ") + log4jServerConfig));
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/log4j2.xml"), (File)log4jServerConfig);
        }
        if (Utils.shouldGenerateResource(this.project, log4jClientConfig = new File(conf, "log4j-client.xml"))) {
            this.getLog().debug((CharSequence)((log4jClientConfig.isFile() ? "Updating " : "Creating ") + log4jClientConfig));
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/log4j2.xml"), (File)log4jClientConfig);
        }
        if (Utils.shouldGenerateResource(this.project, cassandraJar = new File(bin, "cassandra.jar"))) {
            this.getLog().debug((CharSequence)((cassandraJar.isFile() ? "Updating " : "Creating ") + cassandraJar));
            this.createCassandraJar(cassandraJar, CassandraMonitor.class.getName(), cassandraDir);
        }
    }

    private void createCassandraYaml(File cassandraYaml, File data, File commitlog, File savedCaches, File cdcRawDirectory) throws IOException {
        this.createCassandraYaml(cassandraYaml, data, commitlog, savedCaches, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress}, cdcRawDirectory);
    }

    private void createCassandraYaml(File cassandraYaml, File data, File commitlog, File savedCaches, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds, File cdcRawDirectory) throws IOException {
        String defaults = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cassandra.yaml"));
        StringBuilder config = new StringBuilder();
        config.append("data_file_directories:\n").append("    - ").append(data.getAbsolutePath()).append("\n");
        config.append("commitlog_directory: ").append(commitlog).append("\n");
        config.append("cdc_raw_directory: ").append(cdcRawDirectory).append("\n");
        config.append("saved_caches_directory: ").append(savedCaches).append("\n");
        config.append("initial_token: ").append(initialToken == null || "null".equals(initialToken) ? "" : initialToken.toString()).append("\n");
        config.append("listen_address: ").append(listenAddress).append("\n");
        config.append("storage_port: ").append(this.storagePort).append("\n");
        config.append("rpc_address: ").append(rpcAddress).append("\n");
        config.append("native_transport_port: ").append(this.nativeTransportPort).append("\n");
        config.append("start_native_transport: ").append(this.startNativeTransport).append("\n");
        if (seeds != null) {
            config.append("seed_provider: ").append("\n");
            config.append("    - class_name: org.apache.cassandra.locator.SimpleSeedProvider").append("\n");
            config.append("      parameters:").append("\n");
            String sep = "          - seeds: \"";
            for (int i = 0; i < seeds.length; ++i) {
                config.append(sep).append(seeds[i]);
                sep = ", ";
            }
            if (sep.length() == 2) {
                config.append("\"").append("\n");
            }
        }
        FileUtils.fileWrite((String)cassandraYaml.getAbsolutePath(), (String)Utils.merge(Utils.merge(defaults, this.yaml), config.toString()));
    }

    protected Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    protected CommandLine newJavaCommandLine() {
        String exec = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in cassandra-maven-plugin: " + tc));
            exec = tc.findTool("java");
        } else if (OS.isFamilyWindows()) {
            String ex = "java.exe";
            String path = System.getenv("PATH");
            if (path != null) {
                for (String elem : StringUtils.split((String)path, (String)File.pathSeparator)) {
                    File f = new File(new File(elem), ex);
                    if (!f.exists()) continue;
                    exec = ex;
                    break;
                }
            }
        }
        if (exec == null) {
            exec = "java";
        }
        return new CommandLine(exec);
    }

    protected Map<String, String> createEnvironmentVars() {
        HashMap<String, String> enviro = new HashMap<String, String>(System.getenv());
        enviro.put("CASSANDRA_CONF", new File(this.cassandraDir, "conf").getAbsolutePath());
        return enviro;
    }

    protected CommandLine newServiceCommandLine() throws IOException {
        return this.newServiceCommandLine(this.cassandraDir, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress}, true, this.jmxPort);
    }

    protected CommandLine newServiceCommandLine(File cassandraDir, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds, boolean jmxRemoteEnabled, int jmxPort) throws IOException {
        this.createCassandraHome(cassandraDir, listenAddress, rpcAddress, initialToken, seeds);
        CommandLine commandLine = this.newJavaCommandLine();
        commandLine.addArgument("-Xmx" + this.maxMemory + "m");
        if (this.useJdk11Options()) {
            commandLine.addArgument("-Djdk.attach.allowAttachSelf=true");
            commandLine.addArgument("--add-exports=java.base/jdk.internal.misc=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.base/jdk.internal.ref=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.base/sun.nio.ch=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.management.rmi/com.sun.jmx.remote.internal.rmi=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.rmi/sun.rmi.registry=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.rmi/sun.rmi.server=ALL-UNNAMED");
            commandLine.addArgument("--add-exports=java.sql/java.sql=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.lang.module=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.loader=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.reflect=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.math=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.module=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/jdk.internal.util.jar=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.io=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.nio=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/sun.nio.ch=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.util.concurrent=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.util.concurrent.atomic=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.base/java.util=ALL-UNNAMED");
            commandLine.addArgument("--add-opens=java.xml/jdk.xml.internal=ALL-UNNAMED");
        }
        commandLine.addArgument("-Dcassandra.storagedir=" + org.apache.commons.exec.util.StringUtils.quoteArgument((String)cassandraDir.getAbsolutePath()), false);
        if (this.stopKey != null && this.stopPort > 0 && this.stopPort < 65536) {
            commandLine.addArgument("-DSTOP.KEY=" + this.stopKey);
            commandLine.addArgument("-DSTOP.PORT=" + this.stopPort);
            commandLine.addArgument("-DSTOP.HOST=" + listenAddress);
        }
        String log4jConfigurationFile = System.getProperty("log4j.configurationFile", new File(new File(cassandraDir, "conf"), "log4j-server.xml").toURI().toURL().toString());
        commandLine.addArgument("-Dlog4j.configurationFile=" + log4jConfigurationFile);
        commandLine.addArgument("-Dcom.sun.management.jmxremote=" + jmxRemoteEnabled);
        commandLine.addArgument("-DcassandraLogLevel=" + this.logLevel);
        if (jmxRemoteEnabled) {
            commandLine.addArgument("-Dcom.sun.management.jmxremote.port=" + jmxPort);
            commandLine.addArgument("-Dcom.sun.management.jmxremote.ssl=false");
            commandLine.addArgument("-Dcom.sun.management.jmxremote.authenticate=false");
        }
        if (this.systemPropertyVariables != null && !this.systemPropertyVariables.isEmpty()) {
            for (Map.Entry<String, String> entry : this.systemPropertyVariables.entrySet()) {
                commandLine.addArgument("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        commandLine.addArgument("-jar");
        commandLine.addArgument(new File(new File(cassandraDir, "bin"), "cassandra.jar").getAbsolutePath(), false);
        return commandLine;
    }

    protected CommandLine newNodetoolCommandLine(String ... args) throws IOException {
        this.createCassandraHome();
        CommandLine commandLine = this.newJavaCommandLine();
        commandLine.addArgument("-jar");
        commandLine.addArgument(new File(new File(this.cassandraDir, "bin"), "nodetool.jar").getAbsolutePath(), false);
        commandLine.addArgument("--host");
        commandLine.addArgument("127.0.0.1");
        commandLine.addArgument("--port");
        commandLine.addArgument(Integer.toString(this.jmxPort));
        commandLine.addArguments(args);
        return commandLine;
    }

    private static String toPathString(File file) {
        boolean hasSingleQuotes;
        String path = file.getAbsolutePath();
        boolean hasSpaces = path.indexOf(32) != -1;
        boolean hasDoubleQuotes = path.indexOf(34) != -1;
        boolean bl = hasSingleQuotes = path.indexOf(39) != -1;
        if (!(hasSpaces || hasDoubleQuotes || hasSingleQuotes)) {
            return path;
        }
        if (!hasDoubleQuotes) {
            return '\"' + path + '\"';
        }
        if (!hasSingleQuotes) {
            return '\'' + path + '\'';
        }
        return '\"' + StringUtils.escape((String)path, (char[])new char[]{'\"'}, (char)'\'') + '\"';
    }
}

