/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;

@Mojo(name="truncate", threadSafe=true)
public class TruncateCassandraMojo
extends AbstractCassandraMojo {
    @Parameter(property="cassandra.keyspace", required=true)
    protected String keyspace;
    @Parameter(property="cassandra.columnFamily", required=true)
    protected String columnFamily;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.createCassandraHome();
            this.getLog().debug((CharSequence)("Truncating Column Family \"" + this.columnFamily + "\" in Keyspace \"" + this.keyspace + "\"..."));
            StorageProxy.truncateBlocking((String)this.keyspace, (String)this.columnFamily);
            this.getLog().info((CharSequence)("Truncated Column Family \"" + this.columnFamily + "\" in Keyspace \"" + this.keyspace + "\"..."));
        }
        catch (UnavailableException ue) {
            throw new MojoExecutionException("Host(s) must be up in order for a truncate operation to be successful.", (Exception)((Object)ue));
        }
        catch (TimeoutException te) {
            throw new MojoExecutionException("Host did not reply for truncate operation.", (Exception)te);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not construct truncate message", (Exception)ioe);
        }
    }
}

