/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractResolveDependencies;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforceBytecodeVersion
extends AbstractResolveDependencies {
    private static final Map<String, Integer> JDK_TO_MAJOR_VERSION_NUMBER_MAPPING = new HashMap<String, Integer>();
    private String message;
    private String maxJdkVersion;
    int maxJavaMajorVersionNumber = -1;
    int maxJavaMinorVersionNumber = 0;
    private boolean searchTransitive = true;
    private List<String> includes;
    private List<String> excludes;
    private String[] ignoreClasses;
    private List<AbstractResolveDependencies.IgnorableDependency> ignorableDependencies = new ArrayList<AbstractResolveDependencies.IgnorableDependency>();

    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        this.computeParameters();
        Set<Artifact> foundExcludes = this.checkDependencies(this.filterArtifacts(artifacts), this.getLog());
        if (foundExcludes != null && !foundExcludes.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            if (this.message != null) {
                buf.append(this.message + "\n");
            }
            for (Artifact artifact : foundExcludes) {
                buf.append(this.getErrorMessage(artifact));
            }
            this.message = buf.toString() + "Use 'mvn dependency:tree' to locate the source of the banned dependencies.";
            throw new EnforcerRuleException(this.message);
        }
    }

    @Override
    protected boolean isSearchTransitive() {
        return this.searchTransitive;
    }

    protected CharSequence getErrorMessage(Artifact artifact) {
        return "Found Banned Dependency: " + artifact.getId() + "\n";
    }

    private void computeParameters() throws EnforcerRuleException {
        if (this.maxJdkVersion != null && this.maxJavaMajorVersionNumber != -1) {
            throw new IllegalArgumentException("Only maxJdkVersion or maxJavaMajorVersionNumber configuration parameters should be set. Not both.");
        }
        if (this.maxJdkVersion == null && this.maxJavaMajorVersionNumber == -1) {
            throw new IllegalArgumentException("Exactly one of maxJdkVersion or maxJavaMajorVersionNumber options should be set.");
        }
        if (this.maxJdkVersion != null) {
            Integer needle = JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.get(this.maxJdkVersion);
            if (needle == null) {
                throw new IllegalArgumentException("Unknown JDK version given. Should be something like \"1.7\"");
            }
            this.maxJavaMajorVersionNumber = needle;
        }
        if (this.maxJavaMajorVersionNumber == -1) {
            throw new EnforcerRuleException("maxJavaMajorVersionNumber must be set in the plugin configuration");
        }
        if (this.ignoreClasses != null) {
            AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency();
            ignorableDependency.applyIgnoreClasses(this.ignoreClasses, false);
            this.ignorableDependencies.add(ignorableDependency);
        }
    }

    protected Set<Artifact> checkDependencies(Set<Artifact> dependencies, Log log) throws EnforcerRuleException {
        LinkedHashSet<Artifact> problematic = new LinkedHashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            this.getLog().debug((CharSequence)("Analyzing artifact " + artifact));
            if (!this.isBadArtifact(artifact)) continue;
            this.getLog().info((CharSequence)("Artifact " + artifact + " contains .class compiled with incorrect version"));
            problematic.add(artifact);
        }
        return problematic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBadArtifact(Artifact a) throws EnforcerRuleException {
        File f = a.getFile();
        if (!f.getName().endsWith(".jar")) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(f);
            try {
                block11: {
                    this.getLog().debug((CharSequence)(f.getName() + " => " + f.getPath()));
                    byte[] magicAndClassFileVersion = new byte[8];
                    Enumeration<JarEntry> e = jarFile.entries();
                    block6: while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        for (AbstractResolveDependencies.IgnorableDependency i : this.ignorableDependencies) {
                            if (!i.matches(entry.getName())) continue;
                            continue block6;
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append("\t").append(entry.getName()).append(" => ");
                        InputStream is = jarFile.getInputStream(entry);
                        int read = is.read(magicAndClassFileVersion);
                        is.close();
                        assert (read != 8) : "The file" + f + " is corrupt or invalid";
                        int minor = (magicAndClassFileVersion[4] << 8) + magicAndClassFileVersion[5];
                        int major = (magicAndClassFileVersion[6] << 8) + magicAndClassFileVersion[7];
                        builder.append("major=").append(major).append(",minor=").append(minor);
                        this.getLog().debug((CharSequence)builder.toString());
                        if (major <= this.maxJavaMajorVersionNumber && (major != this.maxJavaMajorVersionNumber || minor <= this.maxJavaMinorVersionNumber)) {
                            continue;
                        }
                        break block11;
                    }
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Error while reading jar file", (Exception)e);
        }
    }

    public void setMaxJavaMajorVersionNumber(int maxJavaMajorVersionNumber) {
        this.maxJavaMajorVersionNumber = maxJavaMajorVersionNumber;
    }

    public void setMaxJavaMinorVersionNumber(int maxJavaMinorVersionNumber) {
        this.maxJavaMinorVersionNumber = maxJavaMinorVersionNumber;
    }

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }

    private Set<Artifact> filterArtifacts(Set<Artifact> dependencies) {
        if (this.includes == null && this.excludes == null) {
            return dependencies;
        }
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.includes != null) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (this.excludes != null) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            if (!filter.include(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    static {
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.1", 45);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.2", 46);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.3", 47);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.4", 48);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.5", 49);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.6", 50);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.7", 51);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.8", 52);
    }
}

