/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.arguments;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;

public final class ArgumentBuilder {
    private final Object lock = new Object();
    private static final int NOT_FOUND = -1;
    private static final char DASH = '-';
    private List<String> arguments = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] build() {
        Object object = this.lock;
        synchronized (object) {
            String[] toReturn = new String[this.arguments.size()];
            return this.arguments.toArray(toReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArgumentBuilder withFlag(boolean addFlag, String flag) {
        String toAdd;
        if (!addFlag) {
            return this;
        }
        Validate.notEmpty(flag, "flag");
        Validate.isTrue(!AbstractJaxbMojo.CONTAINS_WHITESPACE.matcher(flag).matches(), "Flags cannot contain whitespace. Got: [" + flag + "]");
        String trimmed = flag.trim();
        Validate.notEmpty(trimmed, "flag");
        String string = toAdd = trimmed.charAt(0) != '-' ? '-' + trimmed : trimmed;
        if (this.getIndexForFlag(toAdd) == -1) {
            Object object = this.lock;
            synchronized (object) {
                this.arguments.add(toAdd);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArgumentBuilder withNamedArgument(boolean addNamedArgument, String name, String value) {
        if (!addNamedArgument) {
            return this;
        }
        Validate.notEmpty(name, "name");
        Validate.notEmpty(value, "value");
        String trimmedName = name.trim();
        String trimmedValue = value.trim();
        Validate.notEmpty(trimmedName, "name");
        Validate.notEmpty(trimmedValue, "value");
        if (!this.updateValueForNamedArgument(name, value)) {
            Object object = this.lock;
            synchronized (object) {
                this.withFlag(true, trimmedName);
                this.arguments.add(value);
            }
        }
        return this;
    }

    public ArgumentBuilder withNamedArgument(String name, String value) {
        Validate.notEmpty(name, "name");
        if (value != null && !value.trim().isEmpty()) {
            this.withNamedArgument(true, name, value.trim());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArgumentBuilder withPreCompiledArguments(List<String> preCompiledArguments) {
        Validate.notNull(preCompiledArguments, "preCompiledArguments");
        Object object = this.lock;
        synchronized (object) {
            for (String current : preCompiledArguments) {
                this.arguments.add(current);
            }
        }
        return this;
    }

    private int getIndexForFlag(String name) {
        Validate.notEmpty(name, "name");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!this.arguments.get(i).equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValueForNamedArgument(String name, String newValue) {
        Validate.notEmpty(name, "name");
        int flagIndex = this.getIndexForFlag(name);
        if (flagIndex == -1) {
            return false;
        }
        int valueIndex = flagIndex + 1;
        Object object = this.lock;
        synchronized (object) {
            this.arguments.set(valueIndex, newValue);
        }
        return true;
    }
}

