package org.codehaus.mojo.keytool;

/*
 * Copyright 2005-2013 The Codehaus
 *
 * Licensed under the Apache License, Version 2.0 (the "License" );
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.keytool.requests.KeyToolPrintCertificateRequest;

import java.io.File;

/**
 * To print the content of a certificate.
 * Implemented as a wrapper around the SDK {@code keytool -printcert} command.
 * See <a href="http://java.sun.com/j2se/1.5.0/docs/tooldocs/windows/keytool.html">keystore documentation</a>.
 *
 * @author tchemit
 * @since 1.2
 */
@Mojo( name = "printCertificate", requiresProject = true, threadSafe = true )
public class PrintCertificateMojo
    extends AbstractKeyToolRequestMojo<KeyToolPrintCertificateRequest>
{

    /**
     * Output in RFC style.
     * See <a href="http://docs.oracle.com/javase/1.5.0/docs/tooldocs/windows/keytool.html#Commands">options</a>.
     *
     * @since 1.2
     */
    @Parameter
    private boolean rfc;

    /**
     * Input file name.
     * See <a href="http://docs.oracle.com/javase/1.5.0/docs/tooldocs/windows/keytool.html#Commands">options</a>.
     *
     * @since 1.2
     */
    @Parameter
    private File file;

    /**
     * SSL server host and port.
     * See <a href="http://docs.oracle.com/javase/1.5.0/docs/tooldocs/windows/keytool.html#Commands">options</a>.
     *
     * @since 1.2
     */
    @Parameter
    private String sslserver;

    /**
     * Signed jar file.
     * See <a href="http://docs.oracle.com/javase/1.5.0/docs/tooldocs/windows/keytool.html#Commands">options</a>.
     *
     * @since 1.2
     */
    @Parameter
    private File jarfile;

    /**
     * Default contructor.
     */
    public PrintCertificateMojo()
    {
        super( KeyToolPrintCertificateRequest.class );
    }

    /** {@inheritDoc} */
    @Override
    protected KeyToolPrintCertificateRequest createKeytoolRequest()
    {
        KeyToolPrintCertificateRequest request = super.createKeytoolRequest();

        request.setRfc( this.rfc );
        request.setFile( this.file );
        request.setSslserver( this.sslserver );
        request.setJarfile( this.jarfile );
        return request;
    }

}
