/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.AbstractDownloadLicensesMojo;

@Mojo(name="aggregate-download-licenses", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, aggregator=true)
public class AggregateDownloadLicensesMojo
extends AbstractDownloadLicensesMojo {
    @Parameter(property="license.skipAggregateDownloadLicenses", defaultValue="false")
    private boolean skipAggregateDownloadLicenses;
    @Parameter(property="license.executeOnlyOnRootModule", alias="aggregateDownloadLicenses.executeOnlyOnRootModule", defaultValue="true")
    private boolean executeOnlyOnRootModule;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    @Override
    protected boolean isSkip() {
        return this.skipAggregateDownloadLicenses || this.executeOnlyOnRootModule && !this.getProject().isExecutionRoot();
    }

    @Override
    protected Set<MavenProject> getDependencies() {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        for (MavenProject reactorProject : this.reactorProjects) {
            SortedMap<String, MavenProject> dependencies = this.getDependencies(reactorProject);
            result.addAll(dependencies.values());
        }
        return result;
    }
}

