/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header;

import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.nuiton.processor.filters.DefaultFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileHeaderFilter
extends DefaultFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FileHeaderFilter.class);
    protected boolean touched;
    protected boolean modified;
    protected boolean detectHeader;
    protected FileHeader fileHeader;
    protected FileHeaderTransformer transformer;
    protected String headerContent;
    protected String processTagHeaderContent;
    protected String fullHeaderContent;

    protected abstract FileHeader getNewHeader(FileHeader var1);

    protected String performInFilter(String ch) {
        LOG.debug("performInFilter - original header =\n{}", (Object)ch);
        if (this.isTouched()) {
            throw new IllegalStateException("Can only have one file header start tag : " + this.getHeader());
        }
        if (this.getMatchIndexFor(ch, this.getHeader()) == -1) {
            FileHeader header;
            String tmp;
            this.touched = true;
            FileHeaderTransformer headerTransformer = this.getTransformer();
            FileHeader oldHeader = headerTransformer.toFileHeader(tmp = headerTransformer.unboxComent(ch));
            FileHeader newFileHeader = this.getNewHeader(oldHeader);
            if (newFileHeader == null) {
                header = oldHeader;
            } else {
                this.modified = true;
                header = newFileHeader;
            }
            return this.transformer.toHeaderContent(header);
        }
        return ch;
    }

    protected String performOutFilter(String ch) {
        LOG.debug(ch);
        return ch;
    }

    protected String getHeader() {
        return this.getTransformer().getProcessStartTag();
    }

    protected String getFooter() {
        return this.getTransformer().getProcessEndTag();
    }

    protected void changeState(DefaultFilter.State newState) {
        super.changeState(newState);
        if (newState == DefaultFilter.State.SEARCH_FOOTER) {
            this.detectHeader = true;
        }
    }

    public String getHeaderContent() {
        if (this.headerContent == null) {
            this.headerContent = this.getTransformer().toString(this.getFileHeader());
        }
        return this.headerContent;
    }

    public String getProcessTagHeaderContent() {
        if (this.processTagHeaderContent == null) {
            this.processTagHeaderContent = this.getTransformer().boxProcessTag(this.getHeaderContent());
        }
        return this.processTagHeaderContent;
    }

    public String getFullHeaderContent() {
        if (this.fullHeaderContent == null) {
            this.fullHeaderContent = this.getTransformer().boxComment(this.getProcessTagHeaderContent(), true);
        }
        return this.fullHeaderContent;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isDetectHeader() {
        return this.detectHeader;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public FileHeaderTransformer getTransformer() {
        return this.transformer;
    }

    public void setFileHeader(FileHeader fileHeader) {
        this.fileHeader = fileHeader;
    }

    public void setTransformer(FileHeaderTransformer transformer) {
        this.transformer = transformer;
    }

    public void reset() {
        this.touched = false;
        this.modified = false;
        this.detectHeader = false;
        this.state = DefaultFilter.State.SEARCH_HEADER;
    }

    public void resetContent() {
        this.headerContent = null;
        this.processTagHeaderContent = null;
        this.fullHeaderContent = null;
    }
}

