/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plugin.hsqldb;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.hsqldb.Server;
import org.hsqldb.WebServer;

public class RunMojo
extends AbstractMojo {
    private String mode;
    private String dbName;
    private String dbPath;
    private boolean silent;
    private boolean trace;
    private boolean tls;
    private int port;
    private boolean isTransient;
    private boolean deleteOnExit;

    public void execute() throws MojoExecutionException {
        Server hsqlServer = this.createServer();
        hsqlServer.setSilent(this.silent);
        hsqlServer.setTrace(this.trace);
        hsqlServer.setTls(this.tls);
        hsqlServer.setDatabaseName(0, this.dbName);
        hsqlServer.setDatabasePath(0, this.persistenceDevice() + this.dbPath + this.dbName + ";sql.enforce_strict_size=true");
        hsqlServer.setLogWriter(null);
        hsqlServer.setErrWriter(null);
        hsqlServer.start();
        this.getLog().info((CharSequence)"HSQL Launched");
        this.getLog().info((CharSequence)hsqlServer.getStateDescriptor());
        this.getLog().info((CharSequence)("Live name: " + hsqlServer.getDatabaseName(0, false)));
        this.deleteFilesOnExit();
    }

    private void deleteFilesOnExit() {
        if (!this.isTransient && this.deleteOnExit) {
            this.deleteOnExitDbFileWithExtensionScript(".log");
            this.deleteOnExitDbFileWithExtensionScript(".properties");
            this.deleteOnExitDbFileWithExtensionScript(".script");
            this.deleteOnExitDbFileWithExtensionScript(".data");
            this.deleteOnExitDbFileWithExtensionScript(".backup");
        }
    }

    private void deleteOnExitDbFileWithExtensionScript(String ext) {
        File dbFile = new File(this.dbName + ext);
        if (dbFile.exists()) {
            dbFile.deleteOnExit();
        }
    }

    private String persistenceDevice() {
        String persistenceDevice = "";
        persistenceDevice = this.isTransient ? "mem:" : "file:";
        return persistenceDevice;
    }

    private Server createServer() throws MojoExecutionException {
        Server hsqlServer = null;
        if (this.mode.equalsIgnoreCase("server")) {
            hsqlServer = new Server();
        } else if (this.mode.equalsIgnoreCase("webserver")) {
            hsqlServer = new WebServer();
            ((WebServer)hsqlServer).setPort(this.port);
        } else {
            throw new MojoExecutionException("This release doesn't support [" + this.mode + "].Try 'server' instead.");
        }
        return hsqlServer;
    }
}

