/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.bootstrap.DependencyCollector;
import org.codehaus.mojo.sonar.bootstrap.MavenUtils;

public class MavenProjectConverter {
    private final Log log;
    private static final char SEPARATOR = ',';
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules.";
    private static final String MODULE_KEY = "sonar.moduleKey";
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String JAVA_SOURCE_PROPERTY = "sonar.java.source";
    private static final String JAVA_TARGET_PROPERTY = "sonar.java.target";
    private static final String LINKS_HOME_PAGE = "sonar.links.homepage";
    private static final String LINKS_CI = "sonar.links.ci";
    private static final String LINKS_ISSUE_TRACKER = "sonar.links.issue";
    private static final String LINKS_SOURCES = "sonar.links.scm";
    private static final String LINKS_SOURCES_DEV = "sonar.links.scm_dev";
    private static final String MAVEN_PACKAGING_POM = "pom";
    private static final String MAVEN_PACKAGING_WAR = "war";
    public static final String ARTIFACT_MAVEN_WAR_PLUGIN = "org.apache.maven.plugins:maven-war-plugin";
    private static final String JAVA_PROJECT_BINARY_DIRS = "sonar.java.binaries";
    private static final String JAVA_PROJECT_LIBRARIES = "sonar.java.libraries";
    private final boolean includePomXml;
    private Properties userProperties;
    private DependencyCollector dependencyCollector;

    public MavenProjectConverter(Log log, boolean includePomXml, DependencyCollector dependencyCollector) {
        this.log = log;
        this.includePomXml = includePomXml;
        this.dependencyCollector = dependencyCollector;
    }

    public Properties configure(List<MavenProject> mavenProjects, MavenProject root, Properties userProperties) throws MojoExecutionException {
        this.userProperties = userProperties;
        HashMap<String, MavenProject> paths = new HashMap<String, MavenProject>();
        HashMap<MavenProject, Properties> propsByModule = new HashMap<MavenProject, Properties>();
        try {
            this.configureModules(mavenProjects, paths, propsByModule);
            Properties props = new Properties();
            props.setProperty("sonar.projectKey", MavenProjectConverter.getSonarKey(root));
            this.rebuildModuleHierarchy(props, paths, propsByModule, root, "");
            if (!propsByModule.isEmpty()) {
                throw new IllegalStateException("Unable to determine structure of project. Probably you use Maven Advanced Reactor Options with a broken tree of modules. \"" + ((MavenProject)propsByModule.keySet().iterator().next()).getName() + "\" is orphan");
            }
            return props;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot configure project", e);
        }
    }

    private boolean rebuildModuleHierarchy(Properties properties, Map<String, MavenProject> paths, Map<MavenProject, Properties> propsByModule, MavenProject current, String prefix) throws IOException {
        Properties currentProps = propsByModule.get(current);
        if (currentProps == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        boolean skipped = "true".equals(currentProps.getProperty("sonar.skip"));
        if (!skipped) {
            for (Map.Entry<Object, Object> prop : currentProps.entrySet()) {
                properties.put(prefix + prop.getKey(), prop.getValue());
            }
        } else {
            this.log.debug((CharSequence)("Module " + current + " skipped by property 'sonar.skip'"));
        }
        propsByModule.remove(current);
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (String modulePathStr : current.getModules()) {
            File modulePath = new File(current.getBasedir(), modulePathStr);
            MavenProject module = MavenProjectConverter.findMavenProject(modulePath, paths);
            if (module == null) continue;
            String moduleId = module.getGroupId() + ":" + module.getArtifactId();
            if (!this.rebuildModuleHierarchy(properties, paths, propsByModule, module, prefix + moduleId + ".")) continue;
            moduleIds.add(moduleId);
        }
        if (!moduleIds.isEmpty() && !skipped) {
            properties.put(prefix + "sonar.modules", StringUtils.join(moduleIds, (char)','));
        }
        return !skipped;
    }

    private void configureModules(List<MavenProject> mavenProjects, Map<String, MavenProject> paths, Map<MavenProject, Properties> propsByModule) throws IOException, MojoExecutionException {
        for (MavenProject pom : mavenProjects) {
            paths.put(pom.getFile().getCanonicalPath(), pom);
            Properties props = new Properties();
            this.merge(pom, props);
            propsByModule.put(pom, props);
        }
    }

    private static MavenProject findMavenProject(File modulePath, Map<String, MavenProject> paths) throws IOException {
        if (modulePath.exists() && modulePath.isDirectory()) {
            for (Map.Entry<String, MavenProject> entry : paths.entrySet()) {
                String pomFileParentDir = new File(entry.getKey()).getParent();
                if (!pomFileParentDir.equals(modulePath.getCanonicalPath())) continue;
                return entry.getValue();
            }
            return null;
        }
        return paths.get(modulePath.getCanonicalPath());
    }

    @VisibleForTesting
    void merge(MavenProject pom, Properties props) throws MojoExecutionException {
        this.defineProjectKey(pom, props);
        props.setProperty("sonar.projectVersion", pom.getVersion());
        props.setProperty("sonar.projectName", pom.getName());
        String description = pom.getDescription();
        if (description != null) {
            props.setProperty("sonar.projectDescription", description);
        }
        MavenProjectConverter.guessJavaVersion(pom, props);
        MavenProjectConverter.guessEncoding(pom, props);
        MavenProjectConverter.convertMavenLinksToProperties(props, pom);
        props.setProperty("sonar.maven.projectDependencies", this.dependencyCollector.toJson(pom));
        this.synchronizeFileSystemAndOtherProps(pom, props);
    }

    private void defineProjectKey(MavenProject pom, Properties props) {
        String key = pom.getModel().getProperties().containsKey("sonar.projectKey") ? pom.getModel().getProperties().getProperty("sonar.projectKey") : MavenProjectConverter.getSonarKey(pom);
        props.setProperty(MODULE_KEY, key);
    }

    private static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    private static void guessEncoding(MavenProject pom, Properties props) {
        String encoding = MavenUtils.getSourceEncoding(pom);
        if (encoding != null) {
            props.setProperty("sonar.sourceEncoding", encoding);
        }
    }

    private static void guessJavaVersion(MavenProject pom, Properties props) {
        String version = MavenUtils.getJavaSourceVersion(pom);
        if (version != null) {
            props.setProperty(JAVA_SOURCE_PROPERTY, version);
        }
        if ((version = MavenUtils.getJavaVersion(pom)) != null) {
            props.setProperty(JAVA_TARGET_PROPERTY, version);
        }
    }

    private static void convertMavenLinksToProperties(Properties props, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_HOME_PAGE, pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES, scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_SOURCES_DEV, scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_CI, ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(props, LINKS_ISSUE_TRACKER, issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(Properties props, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)props.getProperty(propertyKey))) {
            props.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    private void synchronizeFileSystemAndOtherProps(MavenProject pom, Properties props) throws MojoExecutionException {
        props.setProperty("sonar.projectBaseDir", pom.getBasedir().getAbsolutePath());
        File buildDir = MavenProjectConverter.getBuildDir(pom);
        if (buildDir != null) {
            props.setProperty(PROPERTY_PROJECT_BUILDDIR, buildDir.getAbsolutePath());
            props.setProperty("sonar.working.directory", MavenProjectConverter.getSonarWorkDir(pom).getAbsolutePath());
        }
        this.populateBinaries(pom, props);
        this.populateLibraries(pom, props);
        props.putAll((Map<?, ?>)pom.getModel().getProperties());
        props.putAll((Map<?, ?>)this.userProperties);
        List<File> mainDirs = this.mainSources(pom);
        props.setProperty("sonar.sources", StringUtils.join((Object[])MavenProjectConverter.toPaths(mainDirs), (char)','));
        List<File> testDirs = this.testSources(pom);
        if (!testDirs.isEmpty()) {
            props.setProperty("sonar.tests", StringUtils.join((Object[])MavenProjectConverter.toPaths(testDirs), (char)','));
        } else {
            props.remove("sonar.tests");
        }
    }

    private void populateLibraries(MavenProject pom, Properties props) throws MojoExecutionException {
        ArrayList libraries = Lists.newArrayList();
        try {
            if (pom.getCompileClasspathElements() != null) {
                for (String classPathString : pom.getCompileClasspathElements()) {
                    File libPath;
                    if (classPathString.equals(pom.getBuild().getOutputDirectory()) || (libPath = MavenProjectConverter.resolvePath(classPathString, pom.getBasedir())) == null || !libPath.exists()) continue;
                    libraries.add(libPath);
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to populate libraries", (Exception)((Object)e));
        }
        if (!libraries.isEmpty()) {
            String librariesValue = StringUtils.join((Object[])MavenProjectConverter.toPaths(libraries), (char)',');
            props.setProperty("sonar.libraries", librariesValue);
            props.setProperty(JAVA_PROJECT_LIBRARIES, librariesValue);
        }
    }

    private void populateBinaries(MavenProject pom, Properties props) {
        File binaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir());
        if (binaryDir != null && binaryDir.exists()) {
            String binPath = binaryDir.getAbsolutePath();
            props.setProperty("sonar.binaries", binPath);
            props.setProperty(JAVA_PROJECT_BINARY_DIRS, binPath);
        }
    }

    public static File getSonarWorkDir(MavenProject pom) {
        return new File(MavenProjectConverter.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    static File resolvePath(@Nullable String path, File basedir) {
        if (path != null) {
            File file = new File(StringUtils.trim((String)path));
            if (!file.isAbsolute()) {
                file = new File(basedir, path).getAbsoluteFile();
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(Collection<String> paths, File basedir) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            File fileOrDir = MavenProjectConverter.resolvePath(path, basedir);
            if (fileOrDir == null) continue;
            result.add(fileOrDir);
        }
        return result;
    }

    private List<File> mainSources(MavenProject pom) throws MojoExecutionException {
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        if (MAVEN_PACKAGING_WAR.equals(pom.getModel().getPackaging())) {
            sources.add(MavenUtils.getPluginSetting(pom, ARTIFACT_MAVEN_WAR_PLUGIN, "warSourceDirectory", "src/main/webapp"));
        }
        if (this.includePomXml) {
            sources.add(pom.getFile().getPath());
        }
        sources.addAll(pom.getCompileSourceRoots());
        return this.sourcePaths(pom, "sonar.sources", sources);
    }

    private List<File> testSources(MavenProject pom) throws MojoExecutionException {
        return this.sourcePaths(pom, "sonar.tests", pom.getTestCompileSourceRoots());
    }

    private List<File> sourcePaths(MavenProject pom, String propertyKey, Collection<String> mavenPaths) throws MojoExecutionException {
        List<File> filesOrDirs;
        boolean userDefined = false;
        String prop = StringUtils.defaultIfEmpty((String)this.userProperties.getProperty(propertyKey), (String)pom.getProperties().getProperty(propertyKey));
        if (prop != null) {
            List<String> paths = Arrays.asList(StringUtils.split((String)prop, (String)","));
            filesOrDirs = MavenProjectConverter.resolvePaths(paths, pom.getBasedir());
            userDefined = true;
        } else {
            filesOrDirs = MavenProjectConverter.resolvePaths(mavenPaths, pom.getBasedir());
        }
        if (userDefined && !MAVEN_PACKAGING_POM.equals(pom.getModel().getPackaging())) {
            return this.existingPathsOrFail(filesOrDirs, pom, propertyKey);
        }
        return this.removeNested(MavenProjectConverter.keepExistingPaths(filesOrDirs));
    }

    private List<File> existingPathsOrFail(List<File> dirs, MavenProject pom, String propertyKey) throws MojoExecutionException {
        for (File dir : dirs) {
            if (dir.exists()) continue;
            throw new MojoExecutionException(String.format("The directory '%s' does not exist for Maven module %s. Please check the property %s", dir.getAbsolutePath(), pom.getId(), propertyKey));
        }
        return dirs;
    }

    private static List<File> keepExistingPaths(List<File> files) {
        return Lists.newArrayList((Iterable)Collections2.filter(files, (Predicate)new Predicate<File>(){

            public boolean apply(File fileOrDir) {
                return fileOrDir != null && fileOrDir.exists();
            }
        }));
    }

    private List<File> removeNested(List<File> originalPaths) {
        ArrayList<File> result = new ArrayList<File>();
        for (File maybeChild : originalPaths) {
            boolean hasParent = false;
            for (File possibleParent : originalPaths) {
                if (!this.isStrictChild(maybeChild, possibleParent)) continue;
                hasParent = true;
            }
            if (hasParent) continue;
            result.add(maybeChild);
        }
        return result;
    }

    boolean isStrictChild(File maybeChild, File possibleParent) {
        return maybeChild.getAbsolutePath().startsWith(possibleParent.getAbsolutePath()) && !maybeChild.getAbsolutePath().equals(possibleParent.getAbsolutePath());
    }

    private static String[] toPaths(Collection<File> dirs) {
        Collection paths = Collections2.transform(dirs, (Function)new Function<File, String>(){

            public String apply(File dir) {
                return dir.getAbsolutePath();
            }
        });
        return paths.toArray(new String[paths.size()]);
    }
}

