/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public class ArtifactVersions
extends AbstractVersionDetails {
    private final Artifact artifact;
    private final SortedSet<ArtifactVersion> versions;
    private final VersionComparator versionComparator;

    public ArtifactVersions(Artifact artifact, List<ArtifactVersion> versions, VersionComparator versionComparator) {
        this.artifact = artifact;
        this.versionComparator = versionComparator;
        this.versions = new TreeSet<ArtifactVersion>(versionComparator);
        this.versions.addAll(versions);
        if (artifact.getVersion() != null) {
            this.setCurrentVersion(artifact.getVersion());
        }
    }

    public static boolean isVersionInRange(ArtifactVersion version, VersionRange range) {
        if (!range.containsVersion(version)) {
            return false;
        }
        for (Restriction r : range.getRestrictions()) {
            String s;
            if (!r.containsVersion(version)) continue;
            if (!r.isLowerBoundInclusive() && r.getLowerBound() != null && (s = r.getLowerBound().toString()).endsWith("-!") && version.toString().startsWith(s.substring(0, s.length() - 2))) {
                return false;
            }
            if (r.isUpperBoundInclusive() || r.getUpperBound() == null || !(s = r.getUpperBound().toString()).endsWith("-!") || !version.toString().startsWith(s.substring(0, s.length() - 2))) continue;
            return false;
        }
        return true;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getGroupId() {
        return this.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.getArtifact().getArtifactId();
    }

    @Override
    public ArtifactVersion[] getVersions(boolean includeSnapshots) {
        return includeSnapshots ? this.versions.toArray(new ArtifactVersion[0]) : (ArtifactVersion[])this.versions.stream().filter(v -> !ArtifactUtils.isSnapshot((String)v.toString())).toArray(ArtifactVersion[]::new);
    }

    @Override
    public VersionComparator getVersionComparator() {
        return this.versionComparator;
    }

    public String toString() {
        return "ArtifactVersions{artifact=" + this.artifact + ", versions=" + this.versions + ", versionComparator=" + this.versionComparator + '}';
    }
}

