/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionDetails;
import org.codehaus.mojo.versions.ordering.BoundArtifactVersion;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public abstract class AbstractVersionDetails
implements VersionDetails {
    private static final Pattern PREVIEW_PATTERN = Pattern.compile("(?i)(?:.*[-.](alpha|a|beta|b|milestone|m|preview|rc)[-.]?(\\d{0,2}[a-z]?|\\d{6}\\.\\d{4})|\\d{8}(?:\\.?\\d{6})?)$");
    private ArtifactVersion currentVersion = null;
    private boolean includeSnapshots = false;
    protected boolean verboseDetail = true;
    private final Object currentVersionLock = new Object();

    protected AbstractVersionDetails() {
    }

    @Override
    public Restriction restrictionFor(Optional<Segment> scope) throws InvalidSegmentException {
        ArtifactVersion highestLowerBound = this.currentVersion;
        if (this.currentVersion != null) {
            try {
                highestLowerBound = VersionRange.createFromVersionSpec((String)this.currentVersion.toString()).getRestrictions().stream().map(Restriction::getLowerBound).filter(Objects::nonNull).max(this.getVersionComparator()).orElse(this.currentVersion);
            }
            catch (InvalidVersionSpecificationException ignored) {
                ignored.printStackTrace(System.err);
            }
        }
        ArtifactVersion currentVersion = highestLowerBound;
        ArtifactVersion nextVersion = scope.filter(s -> s.isMajorTo(Segment.SUBINCREMENTAL)).map(s -> new BoundArtifactVersion(currentVersion, Segment.of(s.value() + 1))).orElse(currentVersion);
        return new Restriction(nextVersion, false, (ArtifactVersion)scope.filter(Segment.MAJOR::isMajorTo).map(s -> new BoundArtifactVersion(currentVersion, (Segment)s)).orElse(null), false);
    }

    @Override
    public Restriction restrictionForIgnoreScope(Optional<Segment> ignored) {
        ArtifactVersion nextVersion = ignored.map(s -> new BoundArtifactVersion(this.currentVersion, (Segment)s)).orElse(this.currentVersion);
        return new Restriction(nextVersion, false, null, false);
    }

    @Override
    public final boolean isCurrentVersionDefined() {
        return this.getCurrentVersion() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ArtifactVersion getCurrentVersion() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCurrentVersion(ArtifactVersion currentVersion) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.currentVersion = currentVersion;
        }
    }

    @Override
    public final void setCurrentVersion(String currentVersion) {
        this.setCurrentVersion((ArtifactVersion)(currentVersion == null ? null : new DefaultArtifactVersion(currentVersion)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isIncludeSnapshots() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.includeSnapshots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setIncludeSnapshots(boolean includeSnapshots) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.includeSnapshots = includeSnapshots;
        }
    }

    @Override
    public final ArtifactVersion[] getVersions() {
        return this.getVersions(this.isIncludeSnapshots());
    }

    @Override
    public abstract ArtifactVersion[] getVersions(boolean var1);

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, null, includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getVersions(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getVersions(lowerBound, upperBound, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getVersions(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        Restriction restriction = new Restriction(lowerBound, false, upperBound, false);
        return this.getVersions(restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getNewestVersion(lowerBound, upperBound, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        Restriction restriction = new Restriction(lowerBound, false, upperBound, false);
        return this.getNewestVersion(restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, Restriction restriction, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, restriction, includeSnapshots, false);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, Restriction restriction, boolean includeSnapshots, boolean allowDowngrade) {
        return Arrays.stream(this.getVersions(includeSnapshots)).sorted(Collections.reverseOrder()).filter(candidate -> allowDowngrade || versionRange == null || ArtifactVersions.isVersionInRange(candidate, versionRange)).filter(candidate -> restriction == null || this.isVersionInRestriction(restriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).findAny().orElse(null);
    }

    @Override
    public final ArtifactVersion getNewestVersion(Restriction restriction, boolean includeSnapshots) {
        return this.getNewestVersion(null, restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, null, includeSnapshots);
    }

    @Override
    public final boolean containsVersion(String version) {
        for (ArtifactVersion candidate : this.getVersions(true)) {
            if (!version.equals(candidate.toString())) continue;
            return true;
        }
        return false;
    }

    private ArtifactVersion[] getNewerVersions(ArtifactVersion version, boolean includeSnapshots) {
        Restriction restriction = new Restriction(version, false, null, false);
        return this.getVersions(restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getNewerVersions(String version, boolean includeSnapshots) {
        return this.getNewerVersions((ArtifactVersion)new DefaultArtifactVersion(version), includeSnapshots);
    }

    @Override
    @Deprecated
    public final ArtifactVersion[] getNewerVersions(String version, Optional<Segment> upperBoundSegment, boolean includeSnapshots) throws InvalidSegmentException {
        return this.getNewerVersions(version, upperBoundSegment, includeSnapshots, false);
    }

    @Override
    public final ArtifactVersion[] getNewerVersions(String versionString, Optional<Segment> unchangedSegment, boolean includeSnapshots, boolean allowDowngrade) throws InvalidSegmentException {
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(versionString);
        DefaultArtifactVersion lowerBound = allowDowngrade ? (ArtifactVersion)this.getLowerBound((ArtifactVersion)currentVersion, unchangedSegment).map(DefaultArtifactVersion::new).orElse(null) : currentVersion;
        ArtifactVersion upperBound = unchangedSegment.map(arg_0 -> AbstractVersionDetails.lambda$getNewerVersions$7((ArtifactVersion)currentVersion, arg_0)).orElse(null);
        Restriction restriction = new Restriction((ArtifactVersion)lowerBound, allowDowngrade, upperBound, allowDowngrade);
        return this.getVersions(restriction, includeSnapshots);
    }

    @Override
    public Optional<ArtifactVersion> getNewestVersion(String versionString, Optional<Segment> upperBoundSegment, boolean includeSnapshots, boolean allowDowngrade) throws InvalidSegmentException {
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(versionString);
        DefaultArtifactVersion lowerBound = allowDowngrade ? (ArtifactVersion)this.getLowerBound((ArtifactVersion)currentVersion, upperBoundSegment).map(DefaultArtifactVersion::new).orElse(null) : currentVersion;
        ArtifactVersion upperBound = upperBoundSegment.map(arg_0 -> AbstractVersionDetails.lambda$getNewestVersion$8((ArtifactVersion)currentVersion, arg_0)).orElse(null);
        Restriction restriction = new Restriction((ArtifactVersion)lowerBound, allowDowngrade, upperBound, allowDowngrade);
        return Arrays.stream(this.getVersions(includeSnapshots)).filter(candidate -> this.isVersionInRestriction(restriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).max(this.getVersionComparator());
    }

    @Override
    public final ArtifactVersion[] getVersions(Restriction restriction, boolean includeSnapshots) {
        return this.getVersions(null, restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, Restriction restriction, boolean includeSnapshots) {
        return (ArtifactVersion[])Arrays.stream(this.getVersions(includeSnapshots)).filter(candidate -> versionRange == null || ArtifactVersions.isVersionInRange(candidate, versionRange)).filter(candidate -> restriction == null || this.isVersionInRestriction(restriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).sorted(this.getVersionComparator()).distinct().toArray(ArtifactVersion[]::new);
    }

    @Override
    public final ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, Optional<Segment> updateScope, boolean includeSnapshots) {
        try {
            return this.getNewestVersion(this.restrictionFor(updateScope), includeSnapshots);
        }
        catch (InvalidSegmentException e) {
            return null;
        }
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, Optional<Segment> updateScope, boolean includeSnapshots) {
        try {
            return this.getVersions(this.restrictionFor(updateScope), includeSnapshots);
        }
        catch (InvalidSegmentException e) {
            return null;
        }
    }

    @Override
    public final ArtifactVersion getNewestUpdate(Optional<Segment> updateScope) {
        return this.getNewestUpdate(updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(Optional<Segment> updateScope) {
        return this.getAllUpdates(updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestUpdate(Optional<Segment> updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getNewestUpdate(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(Optional<Segment> updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getAllUpdates(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion[] getAllUpdates() {
        return this.getAllUpdates((VersionRange)null, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(VersionRange versionRange) {
        return this.getAllUpdates(versionRange, this.isIncludeSnapshots());
    }

    @Override
    public ArtifactVersion[] getAllUpdates(VersionRange versionRange, boolean includeSnapshots) {
        Restriction restriction = new Restriction(this.getCurrentVersion(), false, null, false);
        return this.getVersions(versionRange, restriction, includeSnapshots);
    }

    protected Optional<String> getLowerBound(ArtifactVersion version, Optional<Segment> unchangedSegment) throws InvalidSegmentException {
        if (!unchangedSegment.isPresent()) {
            return Optional.empty();
        }
        int segmentCount = this.getVersionComparator().getSegmentCount(version);
        if (unchangedSegment.get().value() > segmentCount) {
            throw new InvalidSegmentException(unchangedSegment.get(), segmentCount, version);
        }
        StringBuilder newVersion = new StringBuilder();
        newVersion.append(version.getMajorVersion());
        if (segmentCount > 0) {
            newVersion.append(".").append(unchangedSegment.get().value() >= 1 ? version.getMinorVersion() : 0);
        }
        if (segmentCount > 1) {
            newVersion.append(".").append(unchangedSegment.get().value() >= 2 ? version.getIncrementalVersion() : 0);
        }
        if (segmentCount > 2) {
            if (version.getQualifier() != null) {
                newVersion.append("-").append(unchangedSegment.get().value() >= 3 ? version.getQualifier() : "0");
            } else {
                newVersion.append("-").append(unchangedSegment.get().value() >= 3 ? Integer.valueOf(version.getBuildNumber()) : "0");
            }
        }
        return Optional.of(newVersion.toString());
    }

    public boolean isVersionInRestriction(Restriction restriction, ArtifactVersion candidate) {
        int upper;
        ArtifactVersion lowerBound = restriction.getLowerBound();
        ArtifactVersion upperBound = restriction.getUpperBound();
        boolean includeLower = restriction.isLowerBoundInclusive();
        boolean includeUpper = restriction.isUpperBoundInclusive();
        VersionComparator versionComparator = this.getVersionComparator();
        int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
        int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
        if (lower > 0 || upper < 0) {
            return false;
        }
        return !(!includeLower && lower == 0 || !includeUpper && upper == 0);
    }

    public final ArtifactVersion getReportNewestUpdate(Optional<Segment> updateScope) {
        return this.getArtifactVersionStream(updateScope).min(Collections.reverseOrder(this.getVersionComparator())).orElse(null);
    }

    public final ArtifactVersion[] getReportUpdates(Optional<Segment> updateScope) {
        TreeSet versions = this.getArtifactVersionStream(updateScope).collect(Collectors.toCollection(() -> new TreeSet<ArtifactVersion>(this.getVersionComparator())));
        if (!this.verboseDetail) {
            int major = 0;
            int minor = 0;
            boolean needOneMore = false;
            Iterator it = versions.descendingIterator();
            while (it.hasNext()) {
                ArtifactVersion version = (ArtifactVersion)it.next();
                boolean isPreview = PREVIEW_PATTERN.matcher(version.toString()).matches();
                if (version.getMajorVersion() == major && version.getMinorVersion() == minor) {
                    if (needOneMore && !isPreview) {
                        needOneMore = false;
                        continue;
                    }
                    it.remove();
                    continue;
                }
                major = version.getMajorVersion();
                minor = version.getMinorVersion();
                needOneMore = isPreview;
            }
        }
        return versions.toArray(new ArtifactVersion[0]);
    }

    private Stream<ArtifactVersion> getArtifactVersionStream(Optional<Segment> updateScope) {
        if (this.isCurrentVersionDefined()) {
            try {
                Restriction restriction = this.restrictionFor(updateScope);
                return Arrays.stream(this.getVersions()).filter(candidate -> (this.isIncludeSnapshots() || !ArtifactUtils.isSnapshot((String)candidate.toString())) && this.isVersionInRestriction(restriction, (ArtifactVersion)candidate));
            }
            catch (InvalidSegmentException ignored) {
                ignored.printStackTrace(System.err);
            }
        }
        return Stream.empty();
    }

    private static /* synthetic */ ArtifactVersion lambda$getNewestVersion$8(ArtifactVersion currentVersion, Segment s) {
        return new BoundArtifactVersion(currentVersion, s.isMajorTo(Segment.SUBINCREMENTAL) ? Segment.of(s.value() + 1) : s);
    }

    private static /* synthetic */ ArtifactVersion lambda$getNewerVersions$7(ArtifactVersion currentVersion, Segment s) {
        return new BoundArtifactVersion(currentVersion, s.isMajorTo(Segment.SUBINCREMENTAL) ? Segment.of(s.value() + 1) : s);
    }
}

