/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;
import org.eclipse.aether.version.Version;

public class IgnoreVersionHelper {
    public static final List<String> VALID_TYPES = Collections.unmodifiableList(Arrays.asList("exact", "regex", "range"));
    private static final Map<String, BiFunction<Version, IgnoreVersion, Boolean>> VERSION_MATCHERS = new HashMap<String, BiFunction<Version, IgnoreVersion, Boolean>>();

    private IgnoreVersionHelper() {
    }

    public static boolean isValidType(IgnoreVersion ignoreVersion) {
        return VALID_TYPES.contains(ignoreVersion.getType());
    }

    public static boolean isVersionIgnored(Version version, IgnoreVersion ignoreVersion) {
        return VERSION_MATCHERS.get(ignoreVersion.getType()).apply(version, ignoreVersion);
    }

    private static boolean isVersionIgnoredExact(Version version, IgnoreVersion ignoreVersion) {
        return ignoreVersion.getVersion().equals(version.toString());
    }

    private static boolean isVersionIgnoredRegex(Version version, IgnoreVersion ignoreVersion) {
        return Pattern.compile(ignoreVersion.getVersion()).matcher(version.toString()).matches();
    }

    private static boolean isVersionIgnoredRange(Version version, IgnoreVersion ignoreVersion) {
        try {
            DefaultArtifactVersion aVersion = DefaultArtifactVersionCache.of(version.toString());
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)ignoreVersion.getVersion());
            if (versionRange.hasRestrictions()) {
                return versionRange.containsVersion((ArtifactVersion)aVersion);
            }
            return versionRange.getRecommendedVersion().equals((Object)aVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IgnoreVersionException(e);
        }
    }

    static {
        VERSION_MATCHERS.put("exact", IgnoreVersionHelper::isVersionIgnoredExact);
        VERSION_MATCHERS.put("regex", IgnoreVersionHelper::isVersionIgnoredRegex);
        VERSION_MATCHERS.put("range", IgnoreVersionHelper::isVersionIgnoredRange);
    }

    static class IgnoreVersionException
    extends RuntimeException {
        IgnoreVersionException(Throwable cause) {
            super(cause);
        }
    }
}

