/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;

public class BoundArtifactVersion
implements ArtifactVersion {
    private final Segment segment;
    private final ArtifactVersion comparable;

    public BoundArtifactVersion(String artifactVersion, Segment segment) {
        this.segment = segment;
        StringBuilder versionBuilder = new StringBuilder();
        String[] segments = BoundArtifactVersion.tokens(artifactVersion);
        for (int segNr = 0; segNr <= segments.length || segNr <= Segment.SUBINCREMENTAL.value(); ++segNr) {
            if (segNr < segment.value()) {
                versionBuilder.append(segNr < segments.length ? BoundArtifactVersion.integerItemOrZero(segments[segNr]) : "0");
            } else {
                versionBuilder.append(Integer.MAX_VALUE);
            }
            versionBuilder.append(".");
        }
        versionBuilder.append(Integer.MAX_VALUE);
        this.comparable = DefaultArtifactVersionCache.of(versionBuilder.toString());
    }

    public BoundArtifactVersion(ArtifactVersion artifactVersion, Segment segment) {
        this(artifactVersion.toString(), segment);
    }

    private static String[] tokens(String version) {
        if (version == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int begin = 0;
        for (int end = 0; end <= version.length(); ++end) {
            if (end != version.length() && version.charAt(end) != '.' && version.charAt(end) != '-' && !BoundArtifactVersion.isTokenBoundary(version.charAt(begin), version.charAt(end))) continue;
            if (end > begin) {
                result.add(version.substring(begin, end));
            }
            begin = end + 1;
        }
        return result.toArray(new String[0]);
    }

    private static boolean isTokenBoundary(char c1, char c2) {
        return Character.isDigit(c1) ^ Character.isDigit(c2);
    }

    private static String integerItemOrZero(String item) {
        return StringUtils.isNumeric((CharSequence)item) ? item : "0";
    }

    public Segment getSegment() {
        return this.segment;
    }

    public int compareTo(ArtifactVersion other) {
        if (other == null) {
            return -1;
        }
        return this.comparable.compareTo((Object)other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundArtifactVersion)) {
            return false;
        }
        BoundArtifactVersion that = (BoundArtifactVersion)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getSegment(), (Object)that.getSegment()).append((Object)this.comparable, (Object)that.comparable).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getSegment()).append((Object)this.comparable).toHashCode();
    }

    public int getMajorVersion() {
        return this.comparable.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.comparable.getMinorVersion();
    }

    public int getIncrementalVersion() {
        return this.comparable.getIncrementalVersion();
    }

    public int getBuildNumber() {
        return this.comparable.getBuildNumber();
    }

    public String getQualifier() {
        return this.comparable.getQualifier();
    }

    @Deprecated
    public void parseVersion(String version) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.comparable.toString();
    }
}

